#!/usr/bin/perl -w
###############################################################################
# Name %n  : GPU_detect.pl
# Desc %d  : A special script to check if cudamat can be run in computer
#
# Author: Jie Hou
# Date: 2016/02/02
###############################################################################

my $GLOBAL_PATH='/home/casp11/casp12/tools/dncon1.1/';

$SCRIPT_DIR=$GLOBAL_PATH."scripts/";

# check GPU is detected
print "Checking GPU\n";
my $cmd = $SCRIPT_DIR."check_GPU.py 1>GPU.log  2>GPU.Err";
print("python2 $cmd \n");
system("python2 $cmd");
open(FILE,"GPU.Err");
my $errinfo = 'cannot open shared object';
if (grep{/$errinfo/} <FILE>){
	print "Cudamat failed to run on this computer, setting to CPU to run models\n";
	$device = 'CPU';
}else{
	print "GPU is detected to run cudamat. GPU enabled!\n";
	$device = 'GPU';
}
close FILE;


print "DNcon can be run on ".$device."\n";
