#!/bin/bash
###############################################################################
# Name %n  : convert-list-2-pred-file.sh
# Desc %d  : Convert a list of contacts with scores to casp format
# Input %i : The fasta and list of contacts and output file
# Output %o: A casp RR contact file
#
# Author: Jesse Eickholt
# URL: http://merit.oryo.us
# Date: Tue Jun 21 2011
###############################################################################

if [[ $# -ne 5 ]]; then
  echo "Usage: $0 <target_name> <author> <fasta> <contact_list> <output_file>";
  exit;
fi

target_name=$1;
author=$2;
output_fname=$5;

echo "PFRMAT RR" > $output_fname 
echo "TARGET $target_name" >> $output_fname
echo "AUTHOR $author" >> $output_fname 
echo "REMARK " >> $output_fname
echo "METHOD " >> $output_fname
echo "MODEL 1" >> $output_fname
cat $3 | sed -e '1d' | tr -d '\n' | fold -w 50 >> $output_fname
echo "" >> $output_fname
awk '{if($1 < $2) {printf "%i %i  0  8  %f\n", $1, $2, $3}}' $4 >> $output_fname
echo "END" >> $output_fname

