#!/bin/bash
###############################################################################
# Name %n  : filter-out-top-n.sh
# Desc %d  : Take a three column list (all seperated by one or more spaces) and
#  sort the thrid column in decreasing order, then spit out the top 'n' lines
# Input %i : A file (or stdin) with lines that have 3 values all seperated by
#  at least one space
# Output %o: The top 'n' lines after being sorted
#
# Author: Jesse Eickholt
# URL: http://merit.oryo.us
# Date: Sun Jan 10 2010
###############################################################################

if [[ $# -ne 3 ]]; then
  echo "Usage: $0 <file.txt> <num_to_return> <output_file>"
  exit;
fi

sort -nr -k 3 "$1" | head -n "$2" | awk '{if($3>0){print $0}}' > $3
    
