#!/bin/bash
###############################################################################
# Name %n  : gen-pssm-less-stringent.sh
# Desc %d  : Generate and save a PSSM for a query using psi blast and
#  very lax evalues, for those harder targets
# Input %i : A fasta file and two output file names
# Output %o: The pssm and a report
#
# Author: Jesse Eickholt
# URL: http://merit.oryo.us
# Date: Wed Jan 25 2012
#
# Modified: Jie Hou
# Date: Wed Feb 3 2016
###############################################################################

if [[ $# -ne 3 ]]; then
  echo "Usage: $0 <seq.fasta> <out_fname1(pssm)> <out_fname2(report)>";
  exit;
fi

FASTA=$1
PSSM=$2
REPORT=$3

DB="nr90"


GLOBAL_PATH='/home/casp11/casp12/tools/dncon1.1/';

# Get paths using PATHFINDER
BLAST_PATH="/home/casp13/DNCON2/ncbi-blast-2.2.25+/bin";
BLAST_NR_DB="/home/casp13/DNCON2/databases/nr90-2012";
BLASTMAT="/home/casp13/DNCON2/ncbi-blast-2.2.25+/matrices";

echo "Running PSI-Blast with $DB...";
$BLAST_PATH/psiblast -query "$FASTA" -evalue 10 -inclusion_ethresh 10 -db "$BLAST_NR_DB/$DB" -num_iterations 3 -outfmt "0"\
  -out $REPORT -num_alignments 2000 -out_ascii_pssm $PSSM
