#!/usr/bin/perl -w
###############################################################################
# Name %n  : combine-lists.pl
###############################################################################

use strict;

if (@ARGV lt 2 ) {
  print "Usage: $0 <residue_cnt> <output_fname> <list1> <list2> ...\n";
  exit;
}

my $count = $ARGV[0];
my $output_fname = $ARGV[1];

my %list = ();
for(my $i = 1; $i < $count; $i++) {
  $list{$i} = ();
  for(my $j = 1; $j < $count; $j++) {
    $list{$i}{$j} = {"val" => 0, "count" => 0};
  }
}

for(my $i = 2; $i < @ARGV; $i++) {
  open LIST, "<" . $ARGV[$i] || die "Couldn't open " . $ARGV[1] . "\n";
  my @lines = <LIST>;

  while(my $line_t = shift @lines) {
    my @fields = split(/ \s*/, $line_t);
    if($fields[0] < $fields[1]) {
      $list{$fields[0]}{$fields[1]}->{'val'} += $fields[2];
      $list{$fields[0]}{$fields[1]}->{'count'}++;
    } else {
      $list{$fields[1]}{$fields[0]}->{'val'} += $fields[2];
      $list{$fields[1]}{$fields[0]}->{'count'}++;
    }
  } 

  close LIST;

}


open OUTPUT, ">" . $output_fname;
for(my $i = 1; $i < $count; $i++) {
  for(my $j = $i; $j < $count; $j++) {
    if($list{$i}{$j}->{'count'} > 0) {
      print OUTPUT "$i $j ";
      printf(OUTPUT "%.3f\n",($list{$i}{$j}->{'val'}/$list{$i}{$j}->{'count'}));
    } 
  }
}

close OUTPUT;


