#!/usr/bin/perl -w
###############################################################################
# Name %n  : list-boosted-n-scaled-output.pl
###############################################################################

use strict;

if (@ARGV lt 2 || @ARGV gt 3) {
  print "Usage: $0 <targ-n-probs> <alphas> [comb_count]";
  exit;
}

open ALPHA, "<" . $ARGV[1] || die "Couldn't open alphas\n";
my $line_t = <ALPHA>;
chomp($line_t);
$line_t =~ s/^ \s*//;
close ALPHA;

my @alphas = split(/ \s*/, $line_t);

# Find max value with these alphas to be able to scale output later
my $max = 0;
for(my $i = 0; $i < @alphas; $i++) {
  $max += $alphas[$i];
}

my $round_cnt = @alphas;
if(@ARGV eq 3) {
  $round_cnt = $ARGV[2];
}

open PROBS, "<" . $ARGV[0] || die "Couldn't open target/probs file\n";
my @lines = <PROBS>;
chomp(@lines);
close PROBS;

while (my $line_t = shift @lines) {

  $line_t =~ s/^ \s*//;
  my @fields = split(/ \s*/, $line_t);

  my $val = 0;
  for(my $i = 0; $i < $round_cnt; $i++) {
    if($fields[$i] > 0.5) { 
     $val = $val + $alphas[$i];
    } else {
      $val = $val - $alphas[$i];
    }
  }

  printf "%.4f\n", (($val + $max)/(2*$max));

}

