###############################################################################
# Name %n  : run-cuda-classifier.py
###############################################################################

import sys

GLOBAL_PATH='/home/casp11/casp12/tools/dncon1.1/';

sys.path.insert(0, GLOBAL_PATH+'libs/cudamat-rbm')

import util
import numpy as np
import rbm_numpy 


if len(sys.argv) != 5:
   sys.stderr.write('Usage: '+ sys.argv[0]+ ' feat.npy.dat weight_file(util) output_filename Device')
   print ""
   sys.exit(1)

# load weights
util.load(sys.argv[2]+ '_wghts.dat' , globals())
Device = sys.argv[4]
Device2 = Device.upper()
if Device2 == 'GPU':
   import rbm_cudamat
   import cudamat as cm
# load data, strip off first column since that is the class
data_l1 = np.load(sys.argv[1])
data_l1 = data_l1[:,1:]

# quick sanity check
if (data_l1.shape[1] != l1_vh.shape[0]):  
   sys.stderr.write('Either l1_vh does not exist or there is a mismatch between weight dim and input')
   sys.exit(1)



m_data_l1 = data_l1[0:int(data_l1.shape[0] / 1000)*1000];
m_count = m_data_l1.shape[0]



if Device2 == 'GPU':
    print "GPU enabled"
    # Initialize CUDA
    cm.cublas_init()
    cm.CUDAMatrix.init_random(1)
    if m_count >= 1000:
        m_data_l2 = rbm_cudamat.calc_hidden_probs(m_data_l1, l1_vh, l1_hb, 1000)
        del m_data_l1
        m_data_l3 = rbm_cudamat.calc_hidden_probs(m_data_l2, l2_vh, l2_hb, 1000)
        del m_data_l2
        m_data_l4 = rbm_cudamat.calc_hidden_probs(m_data_l3, l3_vh, l3_hb, 1000)
        del m_data_l3
        m_data_l5 = rbm_cudamat.calc_hidden_probs(m_data_l4, l4_vh, l4_hb, 1000)
        del m_data_l4

        final_probs = m_data_l5
    else:
        final_probs = np.array([])
    cm.cublas_shutdown()
else:
    print "CPU enabled"
    if m_count >= 1000:
        m_data_l2 = rbm_numpy.calc_hidden_probs_batch(m_data_l1, l1_vh, l1_hb, 1000)
        del m_data_l1
        m_data_l3 = rbm_numpy.calc_hidden_probs_batch(m_data_l2, l2_vh, l2_hb, 1000)
        del m_data_l2
        m_data_l4 = rbm_numpy.calc_hidden_probs_batch(m_data_l3, l3_vh, l3_hb, 1000)
        del m_data_l3
        m_data_l5 = rbm_numpy.calc_hidden_probs_batch(m_data_l4, l4_vh, l4_hb, 1000)
        del m_data_l4

        final_probs = m_data_l5
    else:
        final_probs = np.array([])



if data_l1.shape[0] % 1000 != 0:
   rest_data_l1 = data_l1[m_count:,]

   rest_data_l2 = rbm_numpy.calc_hidden_probs(rest_data_l1, l1_vh, l1_hb)
   del rest_data_l1

   rest_data_l3 = rbm_numpy.calc_hidden_probs(rest_data_l2, l2_vh, l2_hb)
   del rest_data_l2

   rest_data_l4 = rbm_numpy.calc_hidden_probs(rest_data_l3, l3_vh, l3_hb)
   del rest_data_l3

   rest_data_l5 = rbm_numpy.calc_hidden_probs(rest_data_l4, l4_vh, l4_hb)
   del rest_data_l4

   final_probs = np.append(final_probs, rest_data_l5)

np.savetxt(sys.argv[3], final_probs, fmt="%f")



