#!/usr/bin/perl -w
###############################################################################
# Name %n  : covert-pred-cm-to-lst.pl
# ID: %#44fefc8eff Tags: %t 
###############################################################################

#use lib '/data/contacts/projects/dbn-short-disc';
#use CMindexer qw(create_res_idx_map);
use strict;

if (@ARGV ne 2) {
  print "Usage: $0 <comments> <output>\n";
  exit;
}

#######################################################################
# Name : create_res_idx_map
# Takes: Padding size, frame size, bandsize and min seperation                                      
# Returns: An array of hashes indexed from 0 giving 
#  offsets to encode a band of a contact map       
###################################################################### 

sub create_res_idx_map {
  my ($padding, $framesize, $bandsize, $min_sep) = @_; 
  my @map = ();

  my $i = 0;
  for(my $j = $padding; $j < $framesize - $padding - $min_sep; $j++) {
    my $offset = $min_sep;
    while($offset <= $min_sep + $bandsize && $j+$offset < $framesize-$padding) {
      $map[$i] = {'offset_1' => $j, 'offset_2' => $j + $offset};
      $i++;
      $offset++;
    }
  }


  return (@map);                                              
}

open COMM, $ARGV[0] || die "Couldn't read comments\n";
my @comments = <COMM>;
chomp(@comments);
close COMM;

open OUTPUT, $ARGV[1] || die "Couldn't read output\n";
my @preds = <OUTPUT>;
chomp(@preds);
close OUTPUT;

# Create cm to index map using values from comment file
my @fields = split(/\|/, $comments[0]);
my @params = split(/\,/, $fields[1]);

my @map = create_res_idx_map($params[0], $params[1], $params[2], $params[3]);

if(@comments ne @preds) { die "Mismatch between comments and output\n"; }


my %contacts = ();

for(my $i = 0; $i < @comments; $i++) {
  # Get index for cm
  my @fields = split(/,/, $comments[$i]);
  my $start_idx = $fields[0];
  $start_idx =~ s/[^0-9]*//;


  # Get values from output
  my @cm = split(/ /, $preds[$i]);
  if(@cm ne @map) { die "Mismatch betweem map and predictions in cm\n"; }
  
  for(my $j = 0; $j < @map; $j++) {
    my $idx_1 = ($start_idx + $map[$j]->{'offset_1'});
    my $idx_2 = ($start_idx + $map[$j]->{'offset_2'}); 
    if(! exists $contacts{$idx_1 . "-" . $idx_2}) {
      $contacts{$idx_1 . "-" . $idx_2} = {'count' => 1, 'value' => $cm[$j]}; 
    } else {
      $contacts{$idx_1 . "-" . $idx_2}->{'count'}++;
      $contacts{$idx_1 . "-" . $idx_2}->{'value'} += $cm[$j];
    }
  }


}

# Average values over maps
foreach my $key_t (keys %contacts) {
  if($contacts{$key_t}->{'count'} > 0) {
    my @idxs = split(/-/, $key_t);
    printf("%d %d %.3f\n", $idxs[0], $idxs[1], 1.0*$contacts{$key_t}->{'value'}/$contacts{$key_t}->{'count'});
  } else {
    my @idxs = split(/-/, $key_t);
    printf("%d %d 0\n", $idxs[0], $idxs[1]);
  }
}





