###############################################################################
# Name %n  : run-classifier.py
###############################################################################

import sys
GLOBAL_PATH='/home/casp11/casp12/tools/dncon1.1/';

sys.path.insert(0, GLOBAL_PATH+'libs/cudamat-rbm')

import util
import numpy as np
from rbm_numpy import calc_hidden_probs

if len(sys.argv) != 4:
   sys.stderr.write('Usage: '+ sys.argv[0]+ ' feat.npy.dat weight_file(util) output_filename')
   print ""
   sys.exit(1)

# load weights
util.load(sys.argv[2]+ '_wghts.dat' , globals())

# load data, strip off first column since that is the class
data_l1 = np.load(sys.argv[1])
#data_l1 = data_l1[:,1:]

# quick sanity check
if (data_l1.shape[1] != l1_vh.shape[0]):  
   sys.stderr.write('Either l1_vh does not exist or there is a mismatch between weight dim and input')
   sys.exit(1)

# Run data thru wringer
data_l2 = calc_hidden_probs(data_l1, l1_vh, l1_hb)
del data_l1

data_l3 = calc_hidden_probs(data_l2, l2_vh, l2_hb)
del data_l2

data_l4 = calc_hidden_probs(data_l3, l3_vh, l3_hb)
del data_l3

final_probs = calc_hidden_probs(data_l4, l4_vh, l4_hb)
del data_l4

out = 1 * (final_probs > .5)

np.savetxt(sys.argv[3], out, fmt="%d")

