#!/bin/bash
###############################################################################
# Name %n  : run-target-w-varied-boost.sh
###############################################################################

if [[ $# -ne 6 ]]; then
  echo "Usage: $0 <model_dir> <fasta> <pssm> <ss_sa> <output_fname> <output dir>";
  exit;
fi

model_dir=$1
fasta_fname=$2
pssm_fname=$3
ss_sa_fname=$4
output_fname=$5
output_dir=$6

model_cnt=15
window_size=12

# Get path to script, works generally but not if code is sourced
abspath=$(cd ${0%/*} && echo $PWD/${0##*/})
BASEPATH=`dirname $abspath`;

# trap cleanup 1 2 3 6

rand=$$
while true; do
   FEAT_FILE=/$output_dir/${rand}_feat
   DAT_FILE=/$output_dir/${rand}_dat
   TARG_FILE=/$output_dir/${rand}_targ
   COMMENT_FILE=/$output_dir/${rand}_comment
   OUTPUT_FILE=/$output_dir/${rand}_output
   TRUE_CONT_LST=/$output_dir/${rand}_true.lst
   PRED_CONT_LST=/$output_dir/${rand}_pred.lst
   PROBS_FILE=/$output_dir/${rand}_probs
   TMP_FILE=/$output_dir/${rand}_tmp
   DUMMY_DIST=/$output_dir/${rand}_dummy.dist
   rand=$[2*$rand]
   if [[ -e FEAT_FILE ]]; then
      continue;
   fi
   if [[ -e DAT_FILE ]]; then
      continue;
   fi
   if [[ -e TARG_FILE ]]; then
      continue;
   fi
   if [[ -e COMMENT_FILE ]]; then
      continue;
   fi
   if [[ -e OUTPUT_FILE ]]; then
      continue;
   fi
   if [[ -e TRUE_CONT_LST ]]; then
      continue;
   fi
   if [[ -e PRED_CONT_LST ]]; then
      continue;
   fi
   if [[ -e PROBS_FILE ]]; then
      continue;
   fi
   if [[ -e TMP_FILE ]]; then
      continue;
   fi
   if [[ -e DUMMY_DIST ]]; then
      continue;
   fi
   break
done

touch $DUMMY_DIST
function cleanup {
  if [[ -e $FEAT_FILE ]]; then
    /bin/rm $FEAT_FILE;
  fi
  if [[ -e $TARG_FILE ]]; then
    /bin/rm $TARG_FILE;
  fi
  if [[ -e $COMMENT_FILE ]]; then
    /bin/rm $COMMENT_FILE;
  fi
  if [[ -e ${DAT_FILE}.npy ]]; then
    /bin/rm ${DAT_FILE}.npy
  fi
  if [[ -e $OUTPUT_FILE ]]; then
    /bin/rm $OUTPUT_FILE
  fi
  if [[ -e $TRUE_CONT_LST ]]; then
    /bin/rm $TRUE_CONT_LST
    /bin/rm $PRED_CONT_LST
  fi
  if [[ -e $PROBS_FILE ]]; then
    /bin/rm $PROBS_FILE
  fi
  if [[ -e $TMP_FILE ]]; then
    /bin/rm $TMP_FILE
  fi
  if [[ -e $DUMMY_DIST ]]; then
    /bin/rm $DUMMY_DIST
  fi
}


# Create feature file
$BASEPATH/create-short-target-features.pl $fasta_fname $pssm_fname $ss_sa_fname \
  $DUMMY_DIST 8 $FEAT_FILE $TARG_FILE $window_size

sed -ne '/^#/p' $TARG_FILE > $COMMENT_FILE

python2 $BASEPATH/feat-2-npy.py $FEAT_FILE $DAT_FILE

echo -n "" > $OUTPUT_FILE
echo "Model count for classifier...$model_cnt"
for i in `seq 1 $model_cnt`; do 
  echo "-> $i"
  # Run through classifier
  python2 $BASEPATH/run-classifier.py ${DAT_FILE}.npy $model_dir/model_${i} $PROBS_FILE

  # After first round strip off residue indices
  if [[ $i -eq 1 ]]; then
    # Combine CMs into a list with help of comments
    $BASEPATH/convert-pred-cm-to-lst.pl $COMMENT_FILE $PROBS_FILE > $PRED_CONT_LST
  else
    # Combine CMs into a list with help of comments
    $BASEPATH/convert-pred-cm-to-lst.pl $COMMENT_FILE $PROBS_FILE | awk '{print $3}' > $PRED_CONT_LST
  fi

  paste -d' ' $OUTPUT_FILE $PRED_CONT_LST > $TMP_FILE
  mv $TMP_FILE $OUTPUT_FILE

done

# Combine outputs with alphas
$BASEPATH/average-listed-output.pl $OUTPUT_FILE $model_dir/alphas.txt $i > $output_fname

cleanup

