/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.LocalTreeToolBar;
import org.emboss.jemboss.gui.filetree.RemoteFileTreePanel;
import org.emboss.jemboss.soap.JembossSoapException;

public class LocalAndRemoteFileTreeFrame
extends JFrame {
    private static DragTree ltree;
    private JMenuItem prefClose;

    public LocalAndRemoteFileTreeFrame(JembossParams mysettings) throws JembossSoapException {
        super("File Manager");
        try {
            final JPanel remotePanel = new JPanel(new BorderLayout());
            RemoteFileTreePanel rtree = new RemoteFileTreePanel(mysettings, false);
            ltree = new DragTree(new File(mysettings.getUserHome()), this, mysettings);
            final JPanel localPanel = new JPanel(new BorderLayout());
            localPanel.add((Component)new LocalTreeToolBar(mysettings), "North");
            JScrollPane localTree = new JScrollPane(ltree);
            final JSplitPane treePane = new JSplitPane(0, localPanel, remotePanel);
            JMenuBar menuBar = new JMenuBar();
            JMenu prefMenu = new JMenu("File");
            prefMenu.setMnemonic(70);
            final Dimension panelSize = new Dimension(210, 270);
            JRadioButtonMenuItem prefV = new JRadioButtonMenuItem("Vertical Split");
            prefMenu.add(prefV);
            prefV.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    treePane.remove(remotePanel);
                    treePane.remove(localPanel);
                    treePane.setOrientation(0);
                    treePane.setTopComponent(localPanel);
                    treePane.setBottomComponent(remotePanel);
                    remotePanel.setPreferredSize(panelSize);
                    localPanel.setPreferredSize(panelSize);
                    LocalAndRemoteFileTreeFrame.this.pack();
                    treePane.setDividerLocation(0.5);
                }
            });
            prefV.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(prefV);
            JRadioButtonMenuItem prefH = new JRadioButtonMenuItem("Horizontal Split");
            prefMenu.add(prefH);
            prefH.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    treePane.remove(remotePanel);
                    treePane.remove(localPanel);
                    treePane.setOrientation(1);
                    treePane.setLeftComponent(localPanel);
                    treePane.setRightComponent(remotePanel);
                    remotePanel.setPreferredSize(panelSize);
                    localPanel.setPreferredSize(panelSize);
                    LocalAndRemoteFileTreeFrame.this.pack();
                    treePane.setDividerLocation(0.5);
                }
            });
            group.add(prefH);
            this.prefClose = new JMenuItem("Close");
            this.prefClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.prefClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LocalAndRemoteFileTreeFrame.this.setVisible(false);
                }
            });
            prefMenu.addSeparator();
            prefMenu.add(this.prefClose);
            menuBar.add(prefMenu);
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            JMenuItem fmh = new JMenuItem("About File Manager");
            fmh.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassLoader cl = this.getClass().getClassLoader();
                    try {
                        URL inURL = cl.getResource("resources/filemgr.html");
                        new Browser(inURL, "resources/filemgr.html");
                    }
                    catch (MalformedURLException mex) {
                        System.out.println("Didn't find resources/filemgr.html");
                    }
                    catch (IOException iex) {
                        System.out.println("Didn't find resources/filemgr.html");
                    }
                }
            });
            helpMenu.add(fmh);
            menuBar.add(helpMenu);
            this.setJMenuBar(menuBar);
            rtree.setPreferredSize(panelSize);
            localTree.setPreferredSize(panelSize);
            localPanel.add((Component)localTree, "Center");
            remotePanel.add((Component)rtree, "Center");
            JComboBox rootSelect = rtree.getRootSelect();
            JPanel lbar = new JPanel(new BorderLayout());
            Dimension d = new Dimension((int)lbar.getPreferredSize().getWidth(), (int)rootSelect.getMinimumSize().getHeight());
            lbar.add((Component)new JLabel(" LOCAL"), "West");
            lbar.setPreferredSize(d);
            localPanel.add((Component)lbar, "South");
            JPanel rbar = new JPanel(new BorderLayout());
            rbar.add((Component)new JLabel(" REMOTE "), "West");
            rbar.add((Component)rootSelect, "East");
            rbar.setPreferredSize(d);
            remotePanel.add((Component)rbar, "South");
            this.getContentPane().add(treePane);
            this.pack();
        }
        catch (JembossSoapException jse) {
            throw new JembossSoapException();
        }
    }

    public void setExit() {
        this.prefClose.setText("Exit");
        this.prefClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.prefClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
    }

    public static DragTree getLocalDragTree() {
        return ltree;
    }
}

