/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;

public class TMscore_mod {
    int nmax = 3000;
    double d;
    double d0;
    double d0_fix;
    int nseqA;
    int nseqB;
    int m_out = -1;
    int m_fix = -1;
    int ier = 0;
    int n_ali;
    int n_cut;
    double score;
    double score_maxsub;
    double score_fix;
    double score10;
    double n_GDT05;
    double n_GDT1;
    double n_GDT2;
    double n_GDT4;
    double n_GDT8;
    double score_max;
    double score_fix_max;
    double rms;
    double drms;
    double armsd;
    double rmsd_ali;
    double rmsd;
    String fname = "";
    String pdb = "";
    String outname = "";
    double d0_search;
    double d_output;
    int[] L_ini = new int[this.nmax];
    int[] iA = new int[this.nmax];
    int[] iB = new int[this.nmax];
    int[] i_ali = new int[this.nmax];
    int[] nresA = new int[this.nmax];
    int[] nresB = new int[this.nmax];
    double[][] u = new double[4][4];
    double[] t = new double[4];
    double[] iq = new double[this.nmax];
    double[] xa = new double[this.nmax];
    double[] ya = new double[this.nmax];
    double[] za = new double[this.nmax];
    double[] xt = new double[this.nmax];
    double[] yt = new double[this.nmax];
    double[] zt = new double[this.nmax];
    double[] xb = new double[this.nmax];
    double[] yb = new double[this.nmax];
    double[] zb = new double[this.nmax];
    double[][] r_1 = new double[4][this.nmax];
    double[][] r_2 = new double[4][this.nmax];
    String sequenceA = "";
    String sequenceB = "";
    String sequenceM = "";
    double score_GDT = 0.0;
    double score_GDT_HA = 0.0;
    double score_maxsub_max = 0.0;
    String supString = "";

    public TMscore_mod(String string, String string2, String string3, String string4) {
        try {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            this.d0_fix = -1.0;
            int[] nArray = new int[this.nmax];
            int[] nArray2 = new int[this.nmax];
            String string5 = "";
            int n5 = 0;
            String[] stringArray = new String[2];
            this.m_out = 1;
            this.outname = string3 + string + "_" + string2 + ".TM";
            this.m_fix = 1;
            this.d0_fix = Double.valueOf(string4);
            stringArray[0] = string3 + string;
            stringArray[1] = string3 + string2;
            string5 = this.readPDB(stringArray[0], this.xa, this.ya, this.za, this.nresA);
            String string6 = "";
            string6 = this.readPDB(stringArray[1], this.xb, this.yb, this.zb, this.nresB);
            this.nseqA = string5.length();
            this.nseqB = string6.length();
            --this.nseqA;
            --this.nseqB;
            int n6 = 0;
            block2: for (n3 = 1; n3 <= this.nseqA; ++n3) {
                for (n5 = 1; n5 <= this.nseqB; ++n5) {
                    if (this.nresA[n3] != this.nresB[n5]) continue;
                    this.iA[++n4] = n3;
                    this.iB[n4] = n5;
                    continue block2;
                }
            }
            this.n_ali = n4;
            if (this.n_ali < 1) {
                System.out.println("There is no common residues in the input structures");
            }
            this.d0 = this.nseqB > 15 ? 1.24 * Math.pow(this.nseqB - 15, 0.3333333333333333) - 1.8 : 0.5;
            if (this.d0 < 0.5) {
                this.d0 = 0.5;
            }
            if (this.m_fix == 1) {
                this.d0 = this.d0_fix;
            }
            this.d0_search = this.d0;
            if (this.d0_search > 8.0) {
                this.d0_search = 8.0;
            }
            if (this.d0_search < 4.5) {
                this.d0_search = 4.5;
            }
            int n7 = 20;
            this.d_output = 5.0;
            if (this.m_fix == 1) {
                this.d_output = this.d0_fix;
            }
            int n8 = 6;
            int n9 = 0;
            int n10 = 4;
            if (this.n_ali < 4) {
                n10 = this.n_ali;
            }
            boolean bl = false;
            for (n3 = 1; n3 <= n8 - 1; ++n3) {
                this.L_ini[++n9] = this.n_ali / (int)Math.pow(2.0, n9 - 1);
                if (this.L_ini[n9] > n10) continue;
                this.L_ini[n9] = n10;
                bl = true;
                break;
            }
            if (!bl) {
                this.L_ini[++n9] = n10;
            }
            this.score_max = 0.0;
            this.score_maxsub_max = -1.0;
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            double d4 = -1.0;
            double d5 = -1.0;
            double d6 = -1.0;
            for (int i = 1; i <= n9; ++i) {
                int n11 = this.L_ini[i];
                int n12 = this.n_ali - n11 + 1;
                block6: for (int j = 1; j <= n12; ++j) {
                    n2 = 0;
                    int n13 = 0;
                    for (n3 = 1; n3 <= n11; ++n3) {
                        n4 = j + n3 - 1;
                        this.r_1[1][n3] = this.xa[this.iA[n4]];
                        this.r_1[2][n3] = this.ya[this.iA[n4]];
                        this.r_1[3][n3] = this.za[this.iA[n4]];
                        this.r_2[1][n3] = this.xb[this.iB[n4]];
                        this.r_2[2][n3] = this.yb[this.iB[n4]];
                        this.r_2[3][n3] = this.zb[this.iB[n4]];
                        nArray[++n13] = n4;
                        ++n2;
                    }
                    this.rms = this.u3b(this.r_1, this.r_2, n2, 1, this.rms, this.u, this.t, this.ier);
                    if (i == 1) {
                        this.rmsd_ali = this.armsd = Math.sqrt(this.rms / (double)n2);
                    }
                    for (n5 = 1; n5 <= this.nseqA; ++n5) {
                        this.xt[n5] = this.t[1] + this.u[1][1] * this.xa[n5] + this.u[1][2] * this.ya[n5] + this.u[1][3] * this.za[n5];
                        this.yt[n5] = this.t[2] + this.u[2][1] * this.xa[n5] + this.u[2][2] * this.ya[n5] + this.u[2][3] * this.za[n5];
                        this.zt[n5] = this.t[3] + this.u[3][1] * this.xa[n5] + this.u[3][2] * this.ya[n5] + this.u[3][3] * this.za[n5];
                    }
                    this.d = this.d0_search - 1.0;
                    this.score_fun(this.xt, this.yt, this.zt, this.xb, this.yb, this.zb);
                    if (this.score_max < this.score) {
                        this.score_max = this.score;
                        n6 = n13;
                        for (n3 = 1; n3 <= n6; ++n3) {
                            nArray2[n3] = nArray[n3];
                        }
                    }
                    if (d < this.score10) {
                        d = this.score10;
                    }
                    if (this.score_maxsub_max < this.score_maxsub) {
                        this.score_maxsub_max = this.score_maxsub;
                    }
                    if (d2 < this.n_GDT05) {
                        d2 = this.n_GDT05;
                    }
                    if (d3 < this.n_GDT1) {
                        d3 = this.n_GDT1;
                    }
                    if (d4 < this.n_GDT2) {
                        d4 = this.n_GDT2;
                    }
                    if (d5 < this.n_GDT4) {
                        d5 = this.n_GDT4;
                    }
                    if (d6 < this.n_GDT8) {
                        d6 = this.n_GDT8;
                    }
                    this.d = this.d0_search + 1.0;
                    for (int k = 1; k <= n7; ++k) {
                        n2 = 0;
                        n13 = 0;
                        for (n3 = 1; n3 <= this.n_cut; ++n3) {
                            n = this.i_ali[n3];
                            this.r_1[1][n3] = this.xa[this.iA[n]];
                            this.r_1[2][n3] = this.ya[this.iA[n]];
                            this.r_1[3][n3] = this.za[this.iA[n]];
                            this.r_2[1][n3] = this.xb[this.iB[n]];
                            this.r_2[2][n3] = this.yb[this.iB[n]];
                            this.r_2[3][n3] = this.zb[this.iB[n]];
                            nArray[++n13] = n;
                            ++n2;
                        }
                        this.rms = this.u3b(this.r_1, this.r_2, n2, 1, this.rms, this.u, this.t, this.ier);
                        for (n5 = 1; n5 <= this.nseqA; ++n5) {
                            this.xt[n5] = this.t[1] + this.u[1][1] * this.xa[n5] + this.u[1][2] * this.ya[n5] + this.u[1][3] * this.za[n5];
                            this.yt[n5] = this.t[2] + this.u[2][1] * this.xa[n5] + this.u[2][2] * this.ya[n5] + this.u[2][3] * this.za[n5];
                            this.zt[n5] = this.t[3] + this.u[3][1] * this.xa[n5] + this.u[3][2] * this.ya[n5] + this.u[3][3] * this.za[n5];
                        }
                        this.score_fun(this.xt, this.yt, this.zt, this.xb, this.yb, this.zb);
                        if (this.score_max < this.score) {
                            this.score_max = this.score;
                            n6 = n13;
                            for (n3 = 1; n3 <= n13; ++n3) {
                                nArray2[n3] = nArray[n3];
                            }
                        }
                        if (d < this.score10) {
                            d = this.score10;
                        }
                        if (this.score_maxsub_max < this.score_maxsub) {
                            this.score_maxsub_max = this.score_maxsub;
                        }
                        if (d2 < this.n_GDT05) {
                            d2 = this.n_GDT05;
                        }
                        if (d3 < this.n_GDT1) {
                            d3 = this.n_GDT1;
                        }
                        if (d4 < this.n_GDT2) {
                            d4 = this.n_GDT2;
                        }
                        if (d5 < this.n_GDT4) {
                            d5 = this.n_GDT4;
                        }
                        if (d6 < this.n_GDT8) {
                            d6 = this.n_GDT8;
                        }
                        if (k == n7) continue block6;
                        if (this.n_cut != n13) continue;
                        n = 0;
                        for (n3 = 1; n3 <= this.n_cut; ++n3) {
                            if (this.i_ali[n3] != nArray[n3]) continue;
                            ++n;
                        }
                        if (this.n_cut == n) continue block6;
                    }
                }
            }
            DecimalFormat decimalFormat = new DecimalFormat("0.0000");
            this.score_GDT = (d3 + d4 + d5 + d6) / (double)(4 * this.nseqB);
            this.score_GDT_HA = (d2 + d3 + d4 + d5) / (double)(4 * this.nseqB);
            n2 = 0;
            for (n3 = 1; n3 <= n6; ++n3) {
                n = nArray2[n3];
                this.r_1[1][n3] = this.xa[this.iA[n]];
                this.r_1[2][n3] = this.ya[this.iA[n]];
                this.r_1[3][n3] = this.za[this.iA[n]];
                this.r_2[1][n3] = this.xb[this.iB[n]];
                this.r_2[2][n3] = this.yb[this.iB[n]];
                this.r_2[3][n3] = this.zb[this.iB[n]];
                ++n2;
            }
            this.rms = this.u3b(this.r_1, this.r_2, n2, 1, this.rms, this.u, this.t, this.ier);
            for (n5 = 1; n5 <= this.nseqA; ++n5) {
                this.xt[n5] = this.t[1] + this.u[1][1] * this.xa[n5] + this.u[1][2] * this.ya[n5] + this.u[1][3] * this.za[n5];
                this.yt[n5] = this.t[2] + this.u[2][1] * this.xa[n5] + this.u[2][2] * this.ya[n5] + this.u[2][3] * this.za[n5];
                this.zt[n5] = this.t[3] + this.u[3][1] * this.xa[n5] + this.u[3][2] * this.ya[n5] + this.u[3][3] * this.za[n5];
            }
            this.d = this.d_output;
            this.score_fun(this.xt, this.yt, this.zt, this.xb, this.yb, this.zb);
            n2 = 0;
            for (n3 = 1; n3 <= this.n_cut; ++n3) {
                n = this.i_ali[n3];
                this.r_1[1][n3] = this.xa[this.iA[n]];
                this.r_1[2][n3] = this.ya[this.iA[n]];
                this.r_1[3][n3] = this.za[this.iA[n]];
                this.r_2[1][n3] = this.xb[this.iB[n]];
                this.r_2[2][n3] = this.yb[this.iB[n]];
                this.r_2[3][n3] = this.zb[this.iB[n]];
                ++n2;
            }
            this.rms = this.u3b(this.r_1, this.r_2, n2, 0, this.rms, this.u, this.t, this.ier);
            this.rmsd = this.armsd = Math.sqrt(this.rms / (double)n2);
            if (this.m_out == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("load inline\nselect atomno<1000\nwireframe .45\nselect none\nselect atomno>1000\nwireframe .15\ncolor white\n");
                for (n3 = 1; n3 <= this.n_cut; ++n3) {
                    String string7 = String.format("select %4d", this.nresA[this.iA[this.i_ali[n3]]]);
                    stringBuffer.append(string7);
                    stringBuffer.append("\ncolor red\n");
                }
                stringBuffer.append("select all\nexit\n");
                String string8 = String.format("REMARK  RMSD of the common residues=%8.3f\n", this.rmsd_ali);
                stringBuffer.append(string8);
                string8 = String.format("REMARK  TM-score=%6.4f (d0=%5.2f)\n", this.score_max, this.d0);
                stringBuffer.append(string8);
                for (n3 = 1; n3 <= this.nseqA; ++n3) {
                    string8 = String.format("ATOM  %5d  CA  %3s%6d    %8.3f%8.3f%8.3f\n", this.nresA[n3], this.NameMap(String.valueOf(string5.charAt(n3))), this.nresA[n3], this.xt[n3], this.yt[n3], this.zt[n3]);
                    stringBuffer.append(string8);
                }
                stringBuffer.append("TER\n");
                for (n3 = 2; n3 <= this.nseqA; ++n3) {
                    string8 = String.format("CONECT%5d%5d\n", this.nresA[n3 - 1], this.nresA[n3]);
                    stringBuffer.append(string8);
                }
                for (n3 = 1; n3 <= this.nseqB; ++n3) {
                    string8 = String.format("ATOM  %5d  CA  %3s%6d    %8.3f%8.3f%8.3f\n", 2000 + this.nresB[n3], this.NameMap(String.valueOf(string6.charAt(n3))), this.nresB[n3], this.xb[n3], this.yb[n3], this.zb[n3]);
                    stringBuffer.append(string8);
                }
                stringBuffer.append("TER\n");
                for (n3 = 2; n3 <= this.nseqB; ++n3) {
                    string8 = String.format("CONECT%5d%5d\n", 2000 + this.nresB[n3 - 1], 2000 + this.nresB[n3]);
                    stringBuffer.append(string8);
                }
                this.supString = stringBuffer.toString();
            }
            for (n3 = 1; n3 <= this.nseqA; ++n3) {
                this.iq[n3] = 0.0;
            }
            double d7 = 0.0;
            for (n3 = 1; n3 <= this.n_cut; ++n3) {
                n5 = this.iA[this.i_ali[n3]];
                n4 = this.iB[this.i_ali[n3]];
                d7 = Math.sqrt((this.xt[n5] - this.xb[n4]) * (this.xt[n5] - this.xb[n4]) + (this.yt[n5] - this.yb[n4]) * (this.yt[n5] - this.yb[n4]) + (this.zt[n5] - this.zb[n4]) * (this.zt[n5] - this.zb[n4]));
                if (!(d7 < this.d_output)) continue;
                this.iq[n5] = 1.0;
            }
            n4 = 0;
            n3 = 1;
            n5 = 1;
            while (n3 <= this.nseqA || n5 <= this.nseqB) {
                if (n3 > this.nseqA && n5 <= this.nseqB) {
                    this.sequenceA = this.sequenceA + '-';
                    this.sequenceB = this.sequenceB + string6.charAt(n5);
                    this.sequenceM = this.sequenceM + ' ';
                    ++n5;
                    continue;
                }
                if (n3 <= this.nseqA && n5 > this.nseqB) {
                    this.sequenceA = this.sequenceA + string5.charAt(n3);
                    this.sequenceB = this.sequenceB + '-';
                    this.sequenceM = this.sequenceM + ' ';
                    ++n3;
                    continue;
                }
                if (this.nresA[n3] == this.nresB[n5]) {
                    this.sequenceA = this.sequenceA + string5.charAt(n3);
                    this.sequenceB = this.sequenceB + string6.charAt(n5);
                    this.sequenceM = this.iq[n3] == 1.0 ? this.sequenceM + ':' : this.sequenceM + ' ';
                    ++n3;
                    ++n5;
                    continue;
                }
                if (this.nresA[n3] < this.nresB[n5]) {
                    this.sequenceA = n3 < this.nseqA ? this.sequenceA + string5.charAt(n3) : this.sequenceA + ' ';
                    this.sequenceB = this.sequenceB + '-';
                    this.sequenceM = this.sequenceM + ' ';
                    ++n3;
                    continue;
                }
                if (this.nresA[n3] <= this.nresB[n5]) continue;
                this.sequenceA = this.sequenceA + '-';
                this.sequenceB = n5 < this.nseqB ? this.sequenceB + string6.charAt(n5) : this.sequenceB + ' ';
                this.sequenceM = this.sequenceM + ' ';
                ++n5;
            }
            this.release_memory();
        }
        catch (Exception exception) {
            System.out.println("Error executing TMscore!" + exception);
        }
    }

    public String readPDB(String string, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray) {
        String string2 = "*";
        String string3 = "";
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null && !string3.startsWith("TER")) {
                if (!string3.startsWith("ATO") || !string3.substring(13, 16).replaceAll("\\s+", "").endsWith("CA")) continue;
                string2 = string2 + this.NameMap(string3.substring(17, 20).toUpperCase());
                dArray[++n] = Float.valueOf(string3.substring(30, 38)).floatValue();
                dArray2[n] = Float.valueOf(string3.substring(38, 46)).floatValue();
                dArray3[n] = Float.valueOf(string3.substring(46, 54)).floatValue();
                nArray[n] = Integer.valueOf(string3.substring(22, 29).replaceAll("\\s+", ""));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public String NameMap(String string) {
        int n;
        String[] stringArray = new String[]{"ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK"};
        String[] stringArray2 = new String[]{"A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "B", "Z", "X"};
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            return stringArray2[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (!stringArray2[n].equals(string)) continue;
            return stringArray[n];
        }
        return "error";
    }

    void score_fun(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        double d = this.d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        while (true) {
            this.n_cut = 0;
            this.n_GDT05 = 0.0;
            this.n_GDT1 = 0.0;
            this.n_GDT2 = 0.0;
            this.n_GDT4 = 0.0;
            this.n_GDT8 = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            for (int i = 1; i <= this.n_ali; ++i) {
                int n = this.iA[i];
                int n2 = this.iB[i];
                d5 = Math.sqrt((dArray[n] - dArray4[n2]) * (dArray[n] - dArray4[n2]) + (dArray2[n] - dArray5[n2]) * (dArray2[n] - dArray5[n2]) + (dArray3[n] - dArray6[n2]) * (dArray3[n] - dArray6[n2]));
                if (d5 < d) {
                    ++this.n_cut;
                    this.i_ali[this.n_cut] = i;
                }
                if (d5 <= 8.0) {
                    this.n_GDT8 += 1.0;
                    if (d5 <= 4.0) {
                        this.n_GDT4 += 1.0;
                        if (d5 <= 2.0) {
                            this.n_GDT2 += 1.0;
                            if (d5 <= 1.0) {
                                this.n_GDT1 += 1.0;
                                if (d5 <= 0.5) {
                                    this.n_GDT05 += 1.0;
                                }
                            }
                        }
                    }
                }
                if (d5 < 3.5) {
                    d2 += 1.0 / (1.0 + d5 / 3.5 * (d5 / 3.5));
                }
                d3 += 1.0 / (1.0 + d5 / this.d0 * (d5 / this.d0));
                if (!(d5 < 10.0)) continue;
                d4 += 1.0 / (1.0 + d5 / this.d0 * (d5 / this.d0));
            }
            if (this.n_cut >= 3 || this.n_ali <= 3) break;
            d += 0.5;
        }
        this.score_maxsub = d2 / (double)this.nseqB;
        this.score = d3 / (double)this.nseqB;
        this.score10 = d4 / (double)this.nseqB;
    }

    public double u3b(double[][] dArray, double[][] dArray2, int n, int n2, double d, double[][] dArray3, double[] dArray4, int n3) {
        double d2;
        double d3;
        int n4;
        int n5;
        int n6;
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[4];
        double[][] dArray7 = new double[4][4];
        double[][] dArray8 = new double[4][4];
        double[][] dArray9 = new double[4][4];
        double[] dArray10 = new double[4];
        double[] dArray11 = new double[7];
        double[] dArray12 = new double[7];
        double d4 = 1.73205080756888;
        double d5 = 0.01;
        int[] nArray = new int[]{-100, 1, 2, 4, 2, 3, 5, 4, 5, 6};
        int[] nArray2 = new int[]{-100, 2, 3, 1, 2};
        boolean bl = false;
        boolean bl2 = false;
        double d6 = 1.0E-9;
        d = 0.0;
        double d7 = 0.0;
        for (n6 = 1; n6 <= 3; ++n6) {
            dArray5[n6] = 0.0;
            dArray6[n6] = 0.0;
            dArray4[n6] = 0.0;
            for (n5 = 1; n5 <= 3; ++n5) {
                dArray3[n6][n5] = 0.0;
                dArray9[n6][n5] = 0.0;
                dArray7[n6][n5] = 0.0;
                if (n6 != n5) continue;
                dArray3[n6][n5] = 1.0;
                dArray7[n6][n5] = 1.0;
            }
        }
        n3 = -1;
        if (n < 1) {
            return -1000.0;
        }
        n3 = -2;
        for (n4 = 1; n4 <= n; ++n4) {
            for (n6 = 1; n6 <= 3; ++n6) {
                dArray5[n6] = dArray5[n6] + dArray[n6][n4];
                dArray6[n6] = dArray6[n6] + dArray2[n6][n4];
            }
        }
        for (n6 = 1; n6 <= 3; ++n6) {
            dArray5[n6] = dArray5[n6] / (double)n;
            dArray6[n6] = dArray6[n6] / (double)n;
        }
        for (n4 = 1; n4 <= n; ++n4) {
            for (n6 = 1; n6 <= 3; ++n6) {
                d7 = d7 + (dArray[n6][n4] - dArray5[n6]) * (dArray[n6][n4] - dArray5[n6]) + (dArray2[n6][n4] - dArray6[n6]) * (dArray2[n6][n4] - dArray6[n6]);
                d3 = dArray2[n6][n4] - dArray6[n6];
                for (n5 = 1; n5 <= 3; ++n5) {
                    dArray9[n6][n5] = dArray9[n6][n5] + d3 * (dArray[n5][n4] - dArray5[n5]);
                }
            }
        }
        double d8 = d2 = dArray9[1][1] * (dArray9[2][2] * dArray9[3][3] - dArray9[2][3] * dArray9[3][2]) - dArray9[1][2] * (dArray9[2][1] * dArray9[3][3] - dArray9[2][3] * dArray9[3][1]) + dArray9[1][3] * (dArray9[2][1] * dArray9[3][2] - dArray9[2][2] * dArray9[3][1]);
        n4 = 0;
        for (n5 = 1; n5 <= 3; ++n5) {
            for (n6 = 1; n6 <= n5; ++n6) {
                dArray11[++n4] = dArray9[1][n6] * dArray9[1][n5] + dArray9[2][n6] * dArray9[2][n5] + dArray9[3][n6] * dArray9[3][n5];
            }
        }
        double d9 = (dArray11[1] + dArray11[3] + dArray11[6]) / 3.0;
        double d10 = (dArray11[3] * dArray11[6] - dArray11[5] * dArray11[5] + dArray11[1] * dArray11[6] - dArray11[4] * dArray11[4] + dArray11[1] * dArray11[3] - dArray11[2] * dArray11[2]) / 3.0;
        d2 *= d2;
        for (n6 = 1; n6 <= 3; ++n6) {
            dArray10[n6] = d9;
        }
        if (d9 > 0.0) {
            double d11;
            int n7;
            int n8;
            d3 = d9 * d9;
            double d12 = d3 - d10;
            double d13 = (d9 * d10 - d2) / 2.0 - d9 * d12;
            if (d12 > 0.0) {
                double d14 = Math.sqrt(d12);
                d3 = d12 * d12 * d12 - d13 * d13;
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                d3 = Math.atan2(Math.sqrt(d3), -d13) / 3.0;
                double d15 = d14 * Math.cos(d3);
                double d16 = d14 * d4 * Math.sin(d3);
                dArray10[1] = d9 + d15 + d15;
                dArray10[2] = d9 - d15 + d16;
                dArray10[3] = d9 - d15 - d16;
                if (n2 != 0) {
                    int n9;
                    for (n8 = 1; n8 <= 3; n8 += 2) {
                        d3 = dArray10[n8];
                        dArray12[1] = (d3 - dArray11[3]) * (d3 - dArray11[6]) - dArray11[5] * dArray11[5];
                        dArray12[2] = (d3 - dArray11[6]) * dArray11[2] + dArray11[4] * dArray11[5];
                        dArray12[3] = (d3 - dArray11[1]) * (d3 - dArray11[6]) - dArray11[4] * dArray11[4];
                        dArray12[4] = (d3 - dArray11[3]) * dArray11[4] + dArray11[2] * dArray11[5];
                        dArray12[5] = (d3 - dArray11[1]) * dArray11[5] + dArray11[2] * dArray11[4];
                        dArray12[6] = (d3 - dArray11[1]) * (d3 - dArray11[3]) - dArray11[2] * dArray11[2];
                        if (Math.abs(dArray12[0]) <= d6) {
                            dArray12[0] = 0.0;
                        }
                        if (Math.abs(dArray12[1]) <= d6) {
                            dArray12[1] = 0.0;
                        }
                        if (Math.abs(dArray12[2]) <= d6) {
                            dArray12[2] = 0.0;
                        }
                        if (Math.abs(dArray12[3]) <= d6) {
                            dArray12[3] = 0.0;
                        }
                        if (Math.abs(dArray12[4]) <= d6) {
                            dArray12[4] = 0.0;
                        }
                        if (Math.abs(dArray12[5]) <= d6) {
                            dArray12[5] = 0.0;
                        }
                        if (Math.abs(dArray12[1]) >= Math.abs(dArray12[3])) {
                            n5 = 1;
                            if (Math.abs(dArray12[1]) < Math.abs(dArray12[6])) {
                                n5 = 3;
                            }
                        } else {
                            n5 = Math.abs(dArray12[3]) >= Math.abs(dArray12[6]) ? 2 : 3;
                        }
                        d3 = 0.0;
                        n5 = 3 * (n5 - 1);
                        for (n6 = 1; n6 <= 3; ++n6) {
                            n7 = nArray[n6 + n5];
                            dArray7[n6][n8] = dArray12[n7];
                            d3 += dArray12[n7] * dArray12[n7];
                        }
                        d3 = d3 > 0.0 ? 1.0 / Math.sqrt(d3) : 0.0;
                        for (n6 = 1; n6 <= 3; ++n6) {
                            dArray7[n6][n8] = dArray7[n6][n8] * d3;
                        }
                    }
                    d3 = dArray7[1][1] * dArray7[1][3] + dArray7[2][1] * dArray7[2][3] + dArray7[3][1] * dArray7[3][3];
                    if (dArray10[1] - dArray10[2] > dArray10[2] - dArray10[3]) {
                        n9 = 3;
                        n4 = 1;
                    } else {
                        n9 = 1;
                        n4 = 3;
                    }
                    d11 = 0.0;
                    for (n6 = 1; n6 <= 3; ++n6) {
                        dArray7[n6][n9] = dArray7[n6][n9] - d3 * dArray7[n6][n4];
                        d11 += dArray7[n6][n9] * dArray7[n6][n9];
                    }
                    if (d11 <= d5) {
                        d11 = 1.0;
                        for (n6 = 1; n6 <= 3; ++n6) {
                            if (d11 < Math.abs(dArray7[n6][n4])) continue;
                            d11 = Math.abs(dArray7[n6][n4]);
                            n5 = n6;
                        }
                        n7 = nArray2[n5];
                        n8 = nArray2[n5 + 1];
                        d11 = Math.sqrt(dArray7[n7][n4] * dArray7[n7][n4] + dArray7[n8][n4] * dArray7[n8][n4]);
                        if (d11 > d5) {
                            dArray7[n5][n9] = 0.0;
                            dArray7[n7][n9] = -dArray7[n8][n4] / d11;
                            dArray7[n8][n9] = dArray7[n7][n4] / d11;
                        } else {
                            bl = true;
                        }
                    } else {
                        d11 = 1.0 / Math.sqrt(d11);
                        for (n6 = 1; n6 <= 3; ++n6) {
                            dArray7[n6][n9] = dArray7[n6][n9] * d11;
                        }
                    }
                    if (!bl) {
                        dArray7[1][2] = dArray7[2][3] * dArray7[3][1] - dArray7[2][1] * dArray7[3][3];
                        dArray7[2][2] = dArray7[3][3] * dArray7[1][1] - dArray7[3][1] * dArray7[1][3];
                        dArray7[3][2] = dArray7[1][3] * dArray7[2][1] - dArray7[1][1] * dArray7[2][3];
                    }
                }
            }
            if (n2 != 0 && !bl) {
                for (n8 = 1; n8 <= 2; ++n8) {
                    d3 = 0.0;
                    for (n6 = 1; n6 <= 3; ++n6) {
                        dArray8[n6][n8] = dArray9[n6][1] * dArray7[1][n8] + dArray9[n6][2] * dArray7[2][n8] + dArray9[n6][3] * dArray7[3][n8];
                        d3 += dArray8[n6][n8] * dArray8[n6][n8];
                    }
                    d3 = d3 > 0.0 ? 1.0 / Math.sqrt(d3) : 0.0;
                    for (n6 = 1; n6 <= 3; ++n6) {
                        dArray8[n6][n8] = dArray8[n6][n8] * d3;
                    }
                }
                d3 = dArray8[1][1] * dArray8[1][2] + dArray8[2][1] * dArray8[2][2] + dArray8[3][1] * dArray8[3][2];
                d11 = 0.0;
                for (n6 = 1; n6 <= 3; ++n6) {
                    dArray8[n6][2] = dArray8[n6][2] - d3 * dArray8[n6][1];
                    d11 += dArray8[n6][2] * dArray8[n6][2];
                }
                if (d11 <= d5) {
                    d11 = 1.0;
                    for (n6 = 1; n6 <= 3; ++n6) {
                        if (d11 < Math.abs(dArray8[n6][1])) continue;
                        d11 = Math.abs(dArray8[n6][1]);
                        n5 = n6;
                    }
                    n7 = nArray2[n5];
                    n8 = nArray2[n5 + 1];
                    d11 = Math.sqrt(dArray8[n7][1] * dArray8[n7][1] + dArray8[n8][1] * dArray8[n8][1]);
                    if (d11 > d5) {
                        dArray8[n5][2] = 0.0;
                        dArray8[n7][2] = -dArray8[n8][1] / d11;
                        dArray8[n8][2] = dArray8[n7][1] / d11;
                    } else {
                        bl2 = true;
                    }
                } else {
                    d11 = 1.0 / Math.sqrt(d11);
                    for (n6 = 1; n6 <= 3; ++n6) {
                        dArray8[n6][2] = dArray8[n6][2] * d11;
                    }
                }
                if (!bl2) {
                    dArray8[1][3] = dArray8[2][1] * dArray8[3][2] - dArray8[2][2] * dArray8[3][1];
                    dArray8[2][3] = dArray8[3][1] * dArray8[1][2] - dArray8[3][2] * dArray8[1][1];
                    dArray8[3][3] = dArray8[1][1] * dArray8[2][2] - dArray8[1][2] * dArray8[2][1];
                    for (n6 = 1; n6 <= 3; ++n6) {
                        for (n5 = 1; n5 <= 3; ++n5) {
                            dArray3[n6][n5] = dArray8[n6][1] * dArray7[n5][1] + dArray8[n6][2] * dArray7[n5][2] + dArray8[n6][3] * dArray7[n5][3];
                        }
                    }
                }
                for (n6 = 1; n6 <= 3; ++n6) {
                    dArray4[n6] = dArray6[n6] - dArray3[n6][1] * dArray5[1] - dArray3[n6][2] * dArray5[2] - dArray3[n6][3] * dArray5[3];
                }
            }
        } else {
            for (n6 = 1; n6 <= 3; ++n6) {
                dArray4[n6] = dArray6[n6] - dArray3[n6][1] * dArray5[1] - dArray3[n6][2] * dArray5[2] - dArray3[n6][3] * dArray5[3];
            }
        }
        for (n6 = 1; n6 <= 3; ++n6) {
            if (dArray10[n6] < 0.0) {
                dArray10[n6] = 0.0;
            }
            dArray10[n6] = Math.sqrt(dArray10[n6]);
        }
        n3 = 0;
        if (dArray10[2] <= dArray10[1] * 1.0E-5) {
            n3 = -1;
        }
        d3 = dArray10[3];
        if (d8 < 0.0) {
            d3 = -d3;
            if (dArray10[2] - dArray10[3] <= dArray10[1] * 1.0E-5) {
                n3 = -1;
            }
        }
        if ((d = d7 - (d3 = d3 + dArray10[2] + dArray10[1]) - d3) < 1.0E-11) {
            d = 0.0;
        }
        return d;
    }

    public String help() {
        String string = "Brief instruction for running TM-score program:\n(For detail: Zhang & Skolnick,  Proteins, 2004 57:702-10)\n                                                          \n1. Run TM-score to compare 'model' and 'native:          \n   >java -jar TMscore.jar model native                   \n                                                         \n2. Run TM-score with an assigned d0, e.g. 5 Angstroms:   \n   >java -jar TMscore.jar model native -d 5              \n                                                         \n3. Run TM-score with superposition output, e.g. 'TM.sup':\n   >java -jar TMscore.jar model native -o TM.sup         \n   To view the superimposed structures by rasmol:        \n   >rasmol -script TM.sup                                \n";
        return string;
    }

    public void release_memory() {
        this.L_ini = null;
        this.iA = null;
        this.iB = null;
        this.i_ali = null;
        this.nresA = null;
        this.nresB = null;
        this.u = null;
        this.t = null;
        this.iq = null;
        this.xa = null;
        this.ya = null;
        this.za = null;
        this.xt = null;
        this.yt = null;
        this.zt = null;
        this.xb = null;
        this.yb = null;
        this.zb = null;
        this.r_1 = null;
        this.r_2 = null;
    }

    public double getTMscore() {
        return this.score_max;
    }

    public double getMaxSubscore() {
        return this.score_maxsub_max;
    }

    public double getGDTscore() {
        return this.score_GDT;
    }

    public double getGDT_HAscore() {
        return this.score_GDT_HA;
    }

    public String getSequenceA() {
        return this.sequenceA;
    }

    public String getSequenceM() {
        return this.sequenceM;
    }

    public String getSequenceB() {
        return this.sequenceB;
    }

    public String getSupString() {
        return this.supString;
    }

    public boolean enoughAlignedResidues() {
        boolean bl = true;
        if (this.n_ali < 1) {
            bl = false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        TMscore_mod tMscore_mod = new TMscore_mod(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        System.out.println("TM-score: " + tMscore_mod.getTMscore());
        System.out.println("MaxSub:   " + tMscore_mod.getMaxSubscore());
        System.out.println("GDT:      " + tMscore_mod.getGDTscore());
        System.out.println("GDT-HA:   " + tMscore_mod.getGDT_HAscore());
        System.out.println(tMscore_mod.getSequenceA());
        System.out.println(tMscore_mod.getSequenceM());
        System.out.println(tMscore_mod.getSequenceB());
    }
}

