!---------------- MODULE BLOCK -------------------
module protein_information
  type residue_type
     integer :: res_type,cis
     character(len=1) :: str_2nd       ! H (helix) S (sheet) L (loop)
     real*8 phi,psi,chi(4)     !Max # of chi dof for a residue
     real*8 r(3,15)  !Max # of atoms for a residue
     real*8 b(14)   !B-factor
  end type residue_type
end module protein_information

module common_sense
  character(len=80), parameter :: res_list=("GLY ALA VAL ILE LEU "//&
       "SER THR ASP ASN GLU GLN LYS ARG CYS MET PHE TYR "//&
       "TRP HIS PRO ")
  character(len=20), parameter :: seq_list=("GAVILSTDNEQKRCMFYWHP")
  character(len=42), parameter :: atom_list(20)=(/       &
       "N  CA C  O  ",                                 &
       "N  CA C  O  CB ",                              &
       "N  CA C  O  CB CG1CG2 ",                       &
       "N  CA C  O  CB CG1CG2CD1",                     &
       "N  CA C  O  CB CG CD1CD2",                     &
       "N  CA C  O  CB OG ",                           &
       "N  CA C  O  CB OG1CG2",                        &
       "N  CA C  O  CB CG OD1OD2",                     &
       "N  CA C  O  CB CG OD1ND2",                     &
       "N  CA C  O  CB CG CD OE1OE2",                  &
       "N  CA C  O  CB CG CD OE1NE2",                  &
       "N  CA C  O  CB CG CD CE NZ ",                  &
       "N  CA C  O  CB CG CD NE CZ NH1NH2",            &
       "N  CA C  O  CB SG ",                           &
       "N  CA C  O  CB CG SD CE ",                     &
       "N  CA C  O  CB CG CD1CD2CE1CE2CZ ",            &
       "N  CA C  O  CB CG CD1CD2CE1CE2CZ OH ",         &
       "N  CA C  O  CB CG CD1CD2NE1CE2CE3CZ2CZ3CH2",   &
       "N  CA C  O  CB CG ND1CD2CE1NE2",               &
       "N  CA C  O  CB CG CD "/)                       
  integer, parameter :: atoms_per_res(20)=(/ &
       4,5,7,8,8,6,7,8,8,9,9,9,11,6,8,11,12,14,10,7/)
  real*8, parameter :: pi=(3.141592653589793D0)
  real*8, parameter,dimension(12) :: length=(/ &
       1.46,     &          !N(i) CA(i)
       1.53,     &            !CA(i) C(i); C C
       1.33,     &            !C(i) N(i+1); ND1 CE1 (HIS) NE2 CE1 (HIS)
       1.24,     &            !C(i) O(i)
       1.53,     &            !CA(i) CB(i)
       1.42,     &            !CB,OG (SER)
       1.49,     &            !CE,NZ (LYS); CB CG (PRO)
       1.81,     &            !CB,SG (CYS)
       1.38,     &            !CG,CD1 (PHE); CZ,OH (TYR); CG,ND1 (HIS)
       1.50,     &            !CB,CG (TRP,HIS) CG,CD (PRO)
       1.36,     &            !CG,CD1 (TRP)
       1.39/)               !CE2,CZ2 (TRP) CH2,CZ3 (TRP)

  real*8, parameter,dimension(16) ::  angle=(/ &
       (1-110/180.)*pi,    &  !N(i) CA(i) C(i); N(i) CA(i) CB(i); CCC
       (1-114./180.)*pi,   &  !CA(i) C(i) N(i+1) ;CB CG1 CD1;CA CB SG (CYS)
       (1-123./180.)*pi,   &  !C(i) N(i+1) CA(i+1); CB CG ND1(HIS)
       (1-125./180.)*pi,   &  !N(i+1) CA(i) O(i)
       124./180.*pi,       &  !N(i) CA(i) C(i) CB(i)
       120./180.*pi,       &  !CG1,CA,CB,CG2 (VAL)
                              !- CG1,CA,CB,CG2 (ILE)
       63.7/180.*pi,       &  !CA,CB,CG (LEU); CB,CG,ND2 (ASN,GLN)
       67.4/180.*pi,       &  !CA,CB,CG (ASP,ASN); CB,CG,CD (GLU,GLN)
                              !CB,CG,SD (MET); ND1,CE1,NE2(HIS)
       61.6/180.*pi,       &  !CB,CG,CD1 (ASP); CE2,CZ2,CH2 (TRP)
       59./180.*pi,        &  !CB,CG,CD1 (ASN,GLN,PHE); CE1,CZ,OH (TYR)
                              !CZ2,CH2,CZ3 (TYR)
       79./180.*pi,        &  !CG,CD,CE (MET)
       53./180.*pi,        &  !CB,CG,CD1 (TRP)
       70./180.*pi,        &  !CG,CD1,NE1 (TRP); CG,ND1,CE1(HIS)
       50./180.*pi,        &  !NE2,CE2,CZ2 (TRP)
       73./180.*pi,        &  !CE1,NE2,CD2 (HIS); CB,CG,CD (PRO)
       75.5/180.*pi/)         !CA,CB,CG (PRO)

  real*8, parameter,dimension(4) :: mass=(/ &
       14.,12.,16.,32./)     !N,C,O,S
  character(len=4), parameter :: mass_list=("NCOS")

  integer, parameter,dimension(20) ::  maxindex=(/ &
       4,5,7,8,8,6,7,8,8,9,9,9,11,6,8,11,14,12,10,7/)

  real*8, parameter :: nh_angle=(60./180.*pi)

end module common_sense

module constant
  real*8, parameter :: one= 1.D0 ,two= 2.D0 , &
       zero= 0.D0 ,large= 9999.D0, small = 1.D-6
end module constant

module energy_function
!     database
  save
  real*8 energy_subunit(1200,19,19),energy_u_pair(19,19)
  real*8 radii(18),welldepth(18)
!     single energy term  
  real*8 r_lj
  real*8 subunit_energy,lj_energy


end module energy_function
