      program decoy_whole_database_analysis_for_XWGG_potential
!     calculating decoys from potential
      use protein_information
      use energy_function
      implicit none
      integer,parameter :: nmax=(1000)

      character*255 dir_decoy,dir_energy,list_decoy,dir_result
      integer num,eof,rank,num1
      real*8 energy,rmsd,native
      character*255 pdblist,filename,pdbname,subset
      character*255 a1,a2,a3,a4,a5,a6
      type(residue_type)residues(nmax)

      call read_input(dir_energy,dir_decoy,list_decoy,dir_result)

      call init(dir_energy)

      open(unit=19,file="out_test",status='replace')
      open(unit=1,file=trim(dir_decoy)//"/list",status='old')
      do

         read(1,*,IOSTAT=eof) pdbname
         if(eof.lt.0)exit

         filename=trim(dir_decoy)//"/"//trim(pdbname)

         call import_pdb(nmax,filename,num,residues)

         call ca_energy(num,residues,energy)

         write(*,"(F15.4)")energy
      enddo

      close(19)
      end
c
      subroutine read_input(dir_energy,dir_decoy,list_decoy,dir_result)
      implicit none 
      character*255 dir_energy,dir_decoy,list_decoy,dir_result,a1
      logical ex

      inquire(file='input.dat',exist=ex)
      if(.not.ex)then
         print *,"Input file not exists!"
         call system("echo energy = ./energy/ >> input.dat")
         call system("echo decoy = ./ >> input.dat")
         call system("echo list = list>> input.dat")
         call system("echo result = ./ >> input.dat")

         print *,"an example input file is generated!"
         call system("cat input.dat")
         print *,"press any key to continue...."
         read(*,*)
      endif

      open(unit=1,file='input.dat',status='old')
      read(1,"(A9,A255)")a1,dir_energy
      read(1,"(A8,A255)")a1,dir_decoy
      read(1,"(A7,A255)")a1,list_decoy
      read(1,"(A9,A255)")a1,dir_result
      close(1)

      return
      end subroutine read_input
