      program OPUS_PSP_calculator
      use protein_information
      use energy_function
      implicit none
      integer,parameter :: nmax=(2000)
      character*255 :: dir_energy

      character*255 pdbname
      integer nres,eof
      real*8 energy
      type(residue_type)residues(nmax)

      open(unit=1,file='config.psp',status='old')
      read(1,"(A255)")dir_energy
      close(1)

      print "(A)",""
      print "(A)","OPUS-PSP 1.0"
      print "(2A)","(c) Copyright 2008 Mingyang Lu, ",
     c      "Athanasios D.Dousis and Jianpeng Ma"
      print "(A)",""
      print "(A)","reference:"
      print "(5A)","OPUS-PSP: An Orientation-dependent ", 
     c         "Statistical All-atom Potential Derived ", 
     c         "from Side-chain Packing. Mingyang Lu, ",
     c         "Athanasios D.Dousis and Jianpeng Ma, JMB",
     c         "(2008) 376, 288-301"
      print "(A)",""

      print "(A)","Input pdbfiles (e.g. 1bvc.pdb)"
      print "(A)",""

      call init(dir_energy)
      r_lj=1.2D0

      do
         read(*,"(A255)",IOSTAT=eof)pdbname
         if(eof.ne.0)exit

         call import_pdb(nmax,pdbname,nres,residues)

         call cal_energy(nres,residues,energy)
         print "(A35,8F12.3)",trim(pdbname),energy,
     c        subunit_energy,lj_energy
      enddo

      end
