#  File src/library/utils/R/MARC.R
#  Part of the R package, http://www.R-project.org
#
#  Copyright (C) 1995-2014 The R Core Team
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  A copy of the GNU General Public License is available at
#  http://www.r-project.org/Licenses/

MARC_relator_db <-
structure(list(term = c("Abridger", "Actor", "Adapter", "Addressee", 
"Analyst", "Animator", "Annotator", "Appellant", "Appellee", 
"Applicant", "Architect", "Arranger", "Art copyist", "Art director", 
"Artist", "Artistic director", "Assignee", "Associated name", 
"Attributed name", "Auctioneer", "Author", "Author in quotations or text abstracts", 
"Author of afterword, colophon, etc.", "Author of dialog", "Author of introduction, etc.", 
"Autographer", "Bibliographic antecedent", "Binder", "Binding designer", 
"Blurb writer", "Book designer", "Book producer", "Bookjacket designer", 
"Bookplate designer", "Bookseller", "Braille embosser", "Broadcaster", 
"Calligrapher", "Cartographer", "Caster", "Censor", "Choreographer", 
"Cinematographer", "Client", "Collection registrar", "Collector", 
"Collotyper", "Colorist", "Commentator", "Commentator for written text", 
"Compiler", "Complainant", "Complainant-appellant", "Complainant-appellee", 
"Composer", "Compositor", "Conceptor", "Conductor", "Conservator", 
"Consultant", "Consultant to a project", "Contestant", "Contestant-appellant", 
"Contestant-appellee", "Contestee", "Contestee-appellant", "Contestee-appellee", 
"Contractor", "Contributor", "Copyright claimant", "Copyright holder", 
"Corrector", "Correspondent", "Costume designer", "Court governed", 
"Court reporter", "Cover designer", "Creator", "Curator", "Dancer", 
"Data contributor", "Data manager", "Dedicatee", "Dedicator", 
"Defendant", "Defendant-appellant", "Defendant-appellee", "Degree granting institution", 
"Degree supervisor", "Delineator", "Depicted", "Depositor", "Designer", 
"Director", "Dissertant", "Distribution place", "Distributor", 
"Donor", "Draftsman", "Dubious author", "Editor", "Editor of compilation", 
"Editor of moving image work", "Electrician", "Electrotyper", 
"Enacting jurisdiction", "Engineer", "Engraver", "Etcher", "Event place", 
"Expert", "Facsimilist", "Field director", "Film director", "Film distributor", 
"Film editor", "Film producer", "Filmmaker", "First party", "Forger", 
"Former owner", "Funder", "Geographic information specialist", 
"Honoree", "Host", "Host institution", "Illuminator", "Illustrator", 
"Inscriber", "Instrumentalist", "Interviewee", "Interviewer", 
"Inventor", "Issuing body", "Judge", "Jurisdiction governed", 
"Laboratory", "Laboratory director", "Landscape architect", "Lead", 
"Lender", "Libelant", "Libelant-appellant", "Libelant-appellee", 
"Libelee", "Libelee-appellant", "Libelee-appellee", "Librettist", 
"Licensee", "Licensor", "Lighting designer", "Lithographer", 
"Lyricist", "Manufacture place", "Manufacturer", "Marbler", "Markup editor", 
"Medium", "Metadata contact", "Metal-engraver", "Minute taker", 
"Moderator", "Monitor", "Music copyist", "Musical director", 
"Musician", "Narrator", "Onscreen presenter", "Opponent", "Organizer", 
"Originator", "Other", "Owner", "Panelist", "Papermaker", "Patent applicant", 
"Patent holder", "Patron", "Performer", "Permitting agency", 
"Photographer", "Plaintiff", "Plaintiff-appellant", "Plaintiff-appellee", 
"Platemaker", "Praeses", "Presenter", "Printer", "Printer of plates", 
"Printmaker", "Process contact", "Producer", "Production company", 
"Production designer", "Production manager", "Production personnel", 
"Production place", "Programmer", "Project director", "Proofreader", 
"Provider", "Publication place", "Publisher", "Publishing director", 
"Puppeteer", "Radio director", "Radio producer", "Recording engineer", 
"Recordist", "Redaktor", "Renderer", "Reporter", "Repository", 
"Research team head", "Research team member", "Researcher", "Respondent", 
"Respondent-appellant", "Respondent-appellee", "Responsible party", 
"Restager", "Restorationist", "Reviewer", "Rubricator", "Scenarist", 
"Scientific advisor", "Screenwriter", "Scribe", "Sculptor", "Second party", 
"Secretary", "Seller", "Set designer", "Setting", "Signer", "Singer", 
"Sound designer", "Speaker", "Sponsor", "Stage director", "Stage manager", 
"Standards body", "Stereotyper", "Storyteller", "Supporting host", 
"Surveyor", "Teacher", "Technical director", "Television director", 
"Television producer", "Thesis advisor", "Transcriber", "Translator", 
"Type designer", "Typographer", "University place", "Videographer", 
"Voice actor", "Witness", "Wood engraver", "Woodcutter", "Writer of accompanying material", 
"Writer of added commentary", "Writer of added lyrics", "Writer of added text", 
"Writer of introduction", "Writer of preface", "Writer of supplementary textual content"
), code = c("abr", "act", "adp", "rcp", "anl", "anm", "ann", 
"apl", "ape", "app", "arc", "arr", "acp", "adi", "art", "ard", 
"asg", "asn", "att", "auc", "aut", "aqt", "aft", "aud", "aui", 
"ato", "ant", "bnd", "bdd", "blw", "bkd", "bkp", "bjd", "bpd", 
"bsl", "brl", "brd", "cll", "ctg", "cas", "cns", "chr", "cng", 
"cli", "cor", "col", "clt", "clr", "cmm", "cwt", "com", "cpl", 
"cpt", "cpe", "cmp", "cmt", "ccp", "cnd", "con", "csl", "csp", 
"cos", "cot", "coe", "cts", "ctt", "cte", "ctr", "ctb", "cpc", 
"cph", "crr", "crp", "cst", "cou", "crt", "cov", "cre", "cur", 
"dnc", "dtc", "dtm", "dte", "dto", "dfd", "dft", "dfe", "dgg", 
"dgs", "dln", "dpc", "dpt", "dsr", "drt", "dis", "dbp", "dst", 
"dnr", "drm", "dub", "edt", "edc", "edm", "elg", "elt", "enj", 
"eng", "egr", "etr", "evp", "exp", "fac", "fld", "fmd", "fds", 
"flm", "fmp", "fmk", "fpy", "frg", "fmo", "fnd", "gis", "hnr", 
"hst", "his", "ilu", "ill", "ins", "itr", "ive", "ivr", "inv", 
"isb", "jud", "jug", "lbr", "ldr", "lsa", "led", "len", "lil", 
"lit", "lie", "lel", "let", "lee", "lbt", "lse", "lso", "lgd", 
"ltg", "lyr", "mfp", "mfr", "mrb", "mrk", "med", "mdc", "mte", 
"mtk", "mod", "mon", "mcp", "msd", "mus", "nrt", "osp", "opn", 
"orm", "org", "oth", "own", "pan", "ppm", "pta", "pth", "pat", 
"prf", "pma", "pht", "ptf", "ptt", "pte", "plt", "pra", "pre", 
"prt", "pop", "prm", "prc", "pro", "prn", "prs", "pmn", "prd", 
"prp", "prg", "pdr", "pfr", "prv", "pup", "pbl", "pbd", "ppt", 
"rdd", "rpc", "rce", "rcd", "red", "ren", "rpt", "rps", "rth", 
"rtm", "res", "rsp", "rst", "rse", "rpy", "rsg", "rsr", "rev", 
"rbr", "sce", "sad", "aus", "scr", "scl", "spy", "sec", "sll", 
"std", "stg", "sgn", "sng", "sds", "spk", "spn", "sgd", "stm", 
"stn", "str", "stl", "sht", "srv", "tch", "tcd", "tld", "tlp", 
"ths", "trc", "trl", "tyd", "tyg", "uvp", "vdg", "vac", "wit", 
"wde", "wdc", "wam", "wac", "wal", "wat", "win", "wpr", "wst"
), description = c("A person, family, or organization contributing to a resource by shortening or condensing the original work but leaving the nature and content of the original work substantially unchanged. For substantial modifications that result in the creation of a new work, see author", 
"A performer contributing to an expression of a work by acting as a cast member or player in a musical or dramatic presentation, etc.", 
"A person or organization who 1) reworks a musical composition, usually for a different medium, or 2) rewrites novels or stories for motion pictures or other audiovisual medium.", 
"A person, family, or organization to whom the correspondence in a work is addressed", 
"A person or organization that reviews, examines and interprets data or information in a specific area", 
"A person contributing to a moving image work or computer program by giving apparent movement to inanimate objects or drawings. For the creator of the drawings that are animated, see artist", 
"A person who makes manuscript annotations on an item", "A person or organization who appeals a lower court's decision", 
"A person or organization against whom an appeal is taken", "A  person or organization responsible for the submission of an application or who is named as eligible for the results of the processing of the application (e.g., bestowing of rights, reward, title, position)", 
"A person, family, or organization responsible for creating an architectural design, including a pictorial representation intended to show how a building, etc., will look when completed. It also oversees the construction of structures", 
"A person, family, or organization contributing to a musical work by rewriting the composition for a medium of performance different from that for which the work was originally intended, or modifying the work for the same medium of performance, etc., such that the musical substance of the original composition remains essentially unchanged. For extensive modification that effectively results in the creation of a new musical work, see composer", 
"A person (e.g., a painter or sculptor) who makes copies of works of visual art", 
"A person contributing to a motion picture or television production by overseeing the artists and craftspeople who build the sets", 
"A person, family, or organization responsible for creating a work by conceiving, and implementing, an original graphic design, drawing, painting, etc. For book illustrators, prefer Illustrator [ill]", 
"A person responsible for controlling the development of the artistic style of an entire production, including the choice of works to be presented and selection of senior production staff", 
"A person or organization to whom a license for printing or publishing has been transferred", 
"A person or organization associated with or found in an item or collection, which cannot be determined to be that of a Former owner [fmo] or other designated relationship indicative of provenance", 
"An author, artist, etc., relating him/her to a resource for which there is or once was substantial authority for designating that person as author, creator, etc. of the work indicative of provenance", 
"A person or organization in charge of the estimation and public auctioning of goods, particularly books, artistic works, etc.", 
"A person, family, or organization responsible for creating a work that is primarily textual in content, regardless of media type (e.g., printed text, spoken word, electronic text, tactile text) or genre (e.g., poems, novels, screenplays, blogs). Use also for persons, etc., creating a new work by paraphrasing, rewriting, or adapting works by another creator such that the modification has substantially changed the nature and content of the original or changed the medium of expression", 
"A person or organization whose work is largely quoted or extracted in works to which he or she did not contribute directly. Such quotations are found particularly in exhibition catalogs, collections of photographs, etc.", 
"A person or organization responsible for an afterword, postface, colophon, etc. but who is not the chief author of a work", 
"A person or organization responsible for the dialog or spoken commentary for a screenplay or sound recording", 
"A person or organization responsible for an introduction, preface, foreword, or other critical introductory matter, but who is not the chief author", 
"A person whose manuscript signature appears on an item", "A person or organization responsible for a resource upon which the resource represented by the bibliographic description is based. This may be appropriate for adaptations, sequels, continuations, indexes, etc.", 
"A person who binds an item", "A person or organization responsible for the binding design of a book, including the type of binding, the type of materials used, and any decorative aspects of the binding", 
"A person or organization responsible for writing a commendation or testimonial for a work, which appears on or within the publication itself, frequently on the back or dust jacket of print publications or on advertising material for all media", 
"A person or organization involved in manufacturing a manifestation by being responsible for the entire graphic design of a book, including arrangement of type and illustration, choice of materials, and process used", 
"A person or organization responsible for the production of books and other print media", 
"A person or organization responsible for the design of flexible covers designed for or published with a book, including the type of materials used, and any decorative aspects of the bookjacket", 
"A person or organization responsible for the design of a book owner's identification label that is most commonly pasted to the inside front cover of a book", 
"A person or organization who makes books and other bibliographic materials available for purchase. Interest in the materials is primarily lucrative", 
"A person, family, or organization involved in manufacturing a resource by embossing Braille cells using a stylus, special embossing printer, or other device", 
"A person, family, or organization involved in broadcasting a resource to an audience via radio, television, webcast, etc.", 
"A person or organization who writes in an artistic hand, usually as a copyist and or engrosser", 
"A person, family, or organization responsible for creating a map, atlas, globe, or other cartographic work", 
"A person, family, or organization involved in manufacturing a resource by pouring a liquid or molten substance into a mold and leaving it to solidify to take the shape of the mold", 
"A person or organization who examines bibliographic resources for the purpose of suppressing parts deemed objectionable on moral, political, military, or other grounds", 
"A person responsible for creating or contributing to a work of movement", 
"A person in charge of photographing a motion picture, who plans the technical aspets of lighting and photographing of scenes, and often assists the director in the choice of angles, camera setups, and lighting moods. He or she may also supervise the further processing of filmed material up to the completion of the work print. Cinematographer is also referred to as director of photography. Do not confuse with videographer", 
"A person or organization for whom another person or organization is acting", 
"A curator who lists or inventories the items in an aggregate work such as a collection of items or works", 
"A curator who brings together items from various sources that are then arranged, described, and cataloged as a collection. A collector is neither the creator of the material nor a person to whom manuscripts in the collection may have been addressed", 
"A person, family, or organization involved in manufacturing a manifestation of photographic prints from film or other colloid that has ink-receptive and ink-repellent surfaces", 
"A person or organization responsible for applying color to drawings, prints, photographs, maps, moving images, etc", 
"A performer contributing to a work by providing interpretation, analysis, or a discussion of the subject matter on a recording, film, or other audiovisual medium", 
"A person or organization responsible for the commentary or explanatory notes about a text. For the writer of manuscript annotations in a printed book, use Annotator", 
"A person, family, or organization responsible for creating a new work (e.g., a bibliography, a directory) through the act of compilation, e.g., selecting, arranging, aggregating, and editing data, information, etc", 
"A person or organization who applies to the courts for redress, usually in an equity proceeding", 
"A complainant who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding", 
"A complainant against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding", 
"A person, family, or organization responsible for creating or contributing to a musical resource by adding music to a work that originally lacked it or supplements it", 
"A person or organization responsible for the creation of metal slug, or molds made of other materials, used to produce the text and images in printed matter", 
"A person or organization responsible for the original idea on which a work is based, this includes the scientific author of an audio-visual item and the conceptor of an advertisement", 
"A performer contributing to a musical resource by leading a performing group (orchestra, chorus, opera, etc.) in a musical or dramatic presentation, etc.", 
"A person or organization responsible for documenting, preserving, or treating printed or manuscript material, works of art, artifacts, or other media", 
"A person or organization relevant to a resource, who is called upon for professional advice or services in a specialized field of knowledge or training", 
"A person or organization relevant to a resource, who is engaged specifically to provide an intellectual overview of a strategic or operational task and by analysis, specification, or instruction, to create or propose a cost-effective course of action or solution", 
"A person(s) or organization who opposes, resists, or disputes, in a court of law, a claim, decision, result, etc.", 
"A contestant who takes an appeal from one court of law or jurisdiction to another to reverse the judgment", 
"A contestant against whom an appeal is taken from one court of law or jurisdiction to another to reverse the judgment", 
"A person(s) or organization defending a claim, decision, result, etc. being opposed, resisted, or disputed in a court of law", 
"A contestee who takes an appeal from one court or jurisdiction to another to reverse the judgment", 
"A contestee against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment", 
"A person or organization relevant to a resource, who enters into a contract with another person or organization to perform a specific", 
"A person, family or organization responsible for making contributions to the resource. This includes those whose work has been contributed to a larger work, such as an anthology, serial publication, or other compilation of individual works. If a more specific role is available, prefer that, e.g. editor, compiler, illustrator", 
"A person or organization listed as a copyright owner at the time of registration. Copyright can be granted or later transferred to another person or organization, at which time the claimant becomes the copyright holder", 
"A person or organization to whom copy and legal rights have been granted or transferred for the intellectual content of a work. The copyright holder, although not necessarily the creator of the work, usually has the exclusive right to benefit financially from the sale and use of the work to which the associated copyright protection applies", 
"A person or organization who is a corrector of manuscripts, such as the scriptorium official who corrected the work of a scribe. For printed matter, use Proofreader", 
"A person or organization who was either the writer or recipient of a letter or other communication", 
"A person, family, or organization that designs the costumes for a moving image production or for a musical or dramatic presentation or entertainment", 
"A court governed by court rules, regardless of their official nature (e.g., laws, administrative regulations)", 
"A person, family, or organization contributing to a resource by preparing a court's opinions for publication", 
"A person or organization responsible for the graphic design of a book cover, album cover, slipcase, box, container, etc. For a person or organization responsible for the graphic design of an entire book, use Book designer; for book jackets, use Bookjacket designer", 
"A person or organization responsible for the intellectual or artistic content of a resource", 
"A person, family, or organization conceiving, aggregating, and/or organizing an exhibition, collection, or other item", 
"A performer who dances in a musical, dramatic, etc., presentation", 
"A person or organization that submits data for inclusion in a database or other collection of data", 
"A person or organization responsible for managing databases or other data sources", 
"A person, family, or organization to whom a resource is dedicated", 
"A person who writes a dedication, which may be a formal statement or in epistolary or verse form", 
"A person or organization who is accused in a criminal proceeding or sued in a civil proceeding", 
"A defendant who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in a legal action", 
"A defendant against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in a legal action", 
"A organization granting an academic degree", "A person overseeing a higher level academic degree", 
"A person or organization executing technical drawings from others' designs", 
"An entity depicted or portrayed in a work, particularly in a work of art", 
"A current owner of an item who deposited the item into the custody of another person, family, or organization, while still retaining ownership", 
"A person, family, or organization responsible for creating a design for an object", 
"A person responsible for the general management and supervision of a filmed performance, a radio or television program, etc.", 
"A person who presents a thesis for a university or higher-level educational degree", 
"A place from which a resource, e.g., a serial, is distributed", 
"A person or organization that has exclusive or shared marketing rights for a resource", 
"A former owner of an item who donated that item to another owner", 
"A person, family, or organization contributing to a resource by an architect, inventor, etc., by making detailed plans or drawings for buildings, ships, aircraft, machines, objects, etc", 
"A person or organization to which authorship has been dubiously or incorrectly ascribed", 
"A person, family, or organization contributing to a resource by revising or elucidating the content, e.g., adding an introduction, notes, or other critical matter. An editor may also prepare a resource for production, publication, or distribution. For major revisions, adaptations, etc., that substantially change the nature and content of the original work, resulting in a new work, see author", 
"A person, family, or organization contributing to a collective or aggregate work by selecting and putting together works, or parts of works, by one or more creators. For compilations of data, information, etc., that result in new works, see compiler", 
"A person, family, or organization responsible for assembling, arranging, and trimming film, video, or other moving image formats, including both visual and audio aspects", 
"A person responsible for setting up a lighting rig and focusing the lights for a production, and running the lighting at a performance", 
"A person or organization who creates a duplicate printing surface by pressure molding and electrodepositing of metal that is then backed up with lead for printing", 
"A jurisdiction enacting a law, regulation, constitution, court rule, etc.", 
"A person or organization that is responsible for technical planning and design, particularly with construction", 
"A person or organization who cuts letters, figures, etc. on a surface, such as a wooden or metal plate used for printing", 
"A person or organization who produces text or images for printing by subjecting metal, glass, or some other surface to acid or the corrosive action of some other substance", 
"A place where an event such as a conference or a concert took place", 
"A person or organization in charge of the description and appraisal of the value of goods, particularly rare items, works of art, etc.", 
"A person or organization that executed the facsimile", "A person or organization that manages or supervises the work done to collect raw data or do research in an actual setting or environment (typically applies to the natural and social sciences)", 
"A director responsible for the general management and supervision of a filmed performance", 
"A person, family, or organization involved in distributing a moving image resource to theatres or other distribution channels", 
"A person who, following the script and in creative cooperation with the Director, selects, arranges, and assembles the filmed material, controls the synchronization of picture and sound, and participates in other post-production tasks such as sound mixing and visual effects processing.  Today, picture editing is often performed digitally.", 
"A producer responsible for most of the business aspects of a film", 
"A person, family or organization responsible for creating an independent or personal film. A filmmaker is individually responsible for the conception and execution of all aspects of the film", 
"A person or organization who is identified as the only party or the party of the first party. In the case of transfer of rights, this is the assignor, transferor, licensor, grantor, etc. Multiple parties can be named jointly as the first party", 
"A person or organization who makes or imitates something of value or importance, especially with the intent to defraud", 
"A person, family, or organization formerly having legal possession of an item", 
"A person or organization that furnished financial support for the production of the work", 
"A person responsible for geographic information system (GIS) development and integration with global positioning system data", 
"A person, family, or organization honored by a work or item (e.g., the honoree of a festschrift, a person to whom a copy is presented)", 
"A performer contributing to a resource by leading a program (often broadcast) that includes other guests, performers, etc. (e.g., talk show host)", 
"An organization hosting the event, exhibit, conference, etc., which gave rise to a resource, but having little or no responsibility for the content of the resource", 
"A person providing decoration to a specific item using precious metals or color, often with elaborate designs and motifs", 
"A person, family, or organization contributing to a resource by supplementing the primary content with drawings, diagrams, photographs, etc. If the work is primarily the artistic content created by this entity, use artist or photographer", 
"A person who has written a statement of dedication or gift", 
"A performer contributing to a resource by playing a musical instrument", 
"A person, family or organization responsible for creating or contributing to a resource by responding to an interviewer, usually a reporter, pollster, or some other information gathering agent", 
"A person, family, or organization responsible for creating or contributing to a resource by acting as an interviewer, reporter, pollster, or some other information gathering agent", 
"A person, family, or organization responsible for creating a new device or process", 
"A person, family or organization issuing a work, such as an official organ of the body", 
"A person who hears and decides on legal matters in court.", 
"A jurisdiction governed by a law, regulation, etc., that was enacted by another jurisdiction", 
"An organization that provides scientific analyses of material samples", 
"A person or organization that manages or supervises work done in a controlled setting or environment", 
"An architect responsible for creating landscape works. This work involves coordinating the arrangement of existing and proposed land features and structures", 
"A person or organization that takes primary responsibility for a particular activity or endeavor. May be combined with another relator term or code to show the greater importance this person or organization has regarding that particular role. If more than one relator is assigned to a heading, use the Lead relator only if it applies to all the relators", 
"A person or organization permitting the temporary use of a book, manuscript, etc., such as for photocopying or microfilming", 
"A person or organization who files a libel in an ecclesiastical or admiralty case", 
"A libelant who takes an appeal from one ecclesiastical court or admiralty to another to reverse the judgment", 
"A libelant against whom an appeal is taken from one ecclesiastical court or admiralty to another to reverse the judgment", 
"A person or organization against whom a libel has been filed in an ecclesiastical court or admiralty", 
"A libelee who takes an appeal from one ecclesiastical court or admiralty to another to reverse the judgment", 
"A libelee against whom an appeal is taken from one ecclesiastical court or admiralty to another to reverse the judgment", 
"An author of a libretto of an opera or other stage work, or an oratorio", 
"A person or organization who is an original recipient of the right to print or publish", 
"A person or organization who is a signer of the license, imprimatur, etc", 
"A person or organization who designs the lighting scheme for a theatrical presentation, entertainment, motion picture, etc.", 
"A person or organization who prepares the stone or plate for lithographic printing, including a graphic artist creating a design directly on the surface from which printing will be done.", 
"An author of the words of a non-dramatic musical work (e.g. the text of a song), except for oratorios", 
"The place of manufacture (e.g., printing, duplicating, casting, etc.) of a resource in a published form", 
"A person or organization responsible for printing, duplicating, casting, etc. a resource", 
"The entity responsible for marbling paper, cloth, leather, etc. used in construction of a resource", 
"A person or organization performing the coding of SGML, HTML, or XML markup of metadata, text, etc.", 
"A person held to be a channel of communication between the earthly world and a world", 
"A person or organization primarily responsible for compiling and maintaining the original description of a metadata set (e.g., geospatial metadata set)", 
"An engraver responsible for decorations, illustrations, letters, etc. cut on a metal surface for printing or decoration", 
"A person, family, or organization responsible for recording the minutes of a meeting", 
"A performer contributing to a resource by leading a program (often broadcast) where topics are discussed, usually with participation of experts in fields related to the discussion", 
"A person or organization that supervises compliance with the contract and is responsible for the report and controls its distribution. Sometimes referred to as the grantee, or controlling agency", 
"A person who transcribes or copies musical notation", "A person who coordinates the activities of the composer, the sound editor, and sound mixers for a moving image production or for a musical or dramatic presentation or entertainment", 
"A person or organization who performs music or contributes to the musical content of a work when it is not possible or desirable to identify the function more precisely", 
"A performer contributing to a resource by reading or speaking in order to give an account of an act, occurrence, course of events, etc", 
"A performer contributing to an expression of a work by appearing on screen in nonfiction moving image materials or introductions to fiction moving image materials to provide contextual or background information. Use when another term (e.g., narrator, host) is either not applicable or not desired", 
"A person or organization responsible for opposing a thesis or dissertation", 
"A person, family, or organization organizing the exhibit, event, conference, etc., which gave rise to a resource", 
"A person or organization performing the work, i.e., the name of a person or organization associated with the intellectual content of the work. This category does not include the publisher or personal affiliation, or sponsor except where it is also the corporate author", 
"A role that has no equivalent in the MARC list.", "A person, family, or organization that currently owns an item or collection, i.e.has legal possession of a resource", 
"A performer contributing to a resource by participating in a program (often broadcast) where topics are discussed, usually with participation of experts in fields related to the discussion", 
"A person or organization responsible for the production of paper, usually from wood, cloth, or other fibrous material", 
"A person or organization that applied for a patent", "A person or organization that was granted the patent referred to by the item", 
"A person or organization responsible for commissioning a work. Usually a patron uses his or her means or influence to support the work of artists, writers, etc. This includes those who commission and pay for individual works", 
"A person contributing to a resource by performing music, acting, dancing, speaking, etc., often in a musical or dramatic presentation, etc. If specific codes are used, [prf] is used for a person whose principal skill is not known or specified", 
"An organization (usually a government agency) that issues permits under which work is accomplished", 
"A person, family, or organization responsible for creating a photographic work", 
"A person or organization who brings a suit in a civil proceeding", 
"A plaintiff who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in a legal proceeding", 
"A plaintiff against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in a legal proceeding", 
"A person, family, or organization involved in manufacturing a manifestation by preparing plates used in the production of printed images and/or text", 
"A person who is the faculty moderator of an academic disputation, normally proposing a thesis and participating in the ensuing disputation", 
"A person or organization mentioned in an “X presents” credit for moving image materials and who is associated with production, finance, or distribution in some way.  A vanity credit;  in early years, normally the head of a studio", 
"A person, family, or organization involved in manufacturing a manifestation of printed text, notated music, etc., from type or plates, such as a book, newspaper, magazine, broadside, score, etc", 
"A person or organization who prints illustrations from plates.", 
"A person or organization who makes a relief, intaglio, or planographic printing surface", 
"A person or organization primarily responsible for performing or initiating a process, such as is done with the collection of metadata sets", 
"A person, family, or organization responsible for most of the business aspects of a production for screen, audio recording, television, webcast, etc. The producer is generally responsible for fund raising, managing the production, hiring key personnel, arranging for distributors, etc.", 
"An organization that is responsible for financial, technical, and organizational management of a production for stage, screen, audio recording, television, webcast, etc.", 
"A person or organization responsible for designing the overall visual appearance of a moving image production", 
"A person responsible for all technical and business matters in a production", 
"A person or organization associated with the production (props, lighting, special effects, etc.) of a musical or dramatic presentation or entertainment", 
"The place of production (e.g., inscription, fabrication, construction, etc.) of a resource in an unpublished form", 
"A person, family, or organization responsible for creating a computer program", 
"A person or organization with primary responsibility for all essential aspects of a project, has overall responsibility for managing projects, or provides overall direction to a project manager", 
"A person who corrects printed matter. For manuscripts, use Corrector [crr]", 
"A person or organization who produces, publishes, manufactures, or distributes a resource if specific codes are not desired (e.g. [mfr], [pbl])", 
"The place where a resource is published", "A person or organization responsible for publishing, releasing, or issuing a resource", 
"A person or organization who presides over the elaboration of a collective work to ensure its coherence or continuity. This includes editors-in-chief, literary editors, editors of series, etc.", 
"A performer contributing to a resource by manipulating, controlling, or directing puppets or marionettes in a moving image production or a musical or dramatic presentation or entertainment", 
"A director responsible for the general management and supervision of a radio program", 
"A producer responsible for most of the business aspects of a radio program", 
"A person contributing to a resource by supervising the technical aspects of a sound or video recording session", 
"A person or organization who uses a recording device to capture sounds and/or video during a recording session, including field recordings of natural sounds, folkloric events, music, etc.", 
"A person or organization who writes or develops the framework for an item without being intellectually responsible for its content", 
"A person or organization who prepares drawings of architectural designs (i.e., renderings) in accurate, representational perspective to show what the project will look like when completed", 
"A person or organization who writes or presents reports of news or current events on air or in print", 
"An organization that hosts data or material culture objects and provides services to promote long term, consistent and shared use of those data or objects", 
"A person who directed or managed a research project", "A person who participated in a research project but whose role did not involve direction or management of it", 
"A person or organization responsible for performing research", 
"A person or organization who makes an answer to the courts pursuant to an application for redress (usually in an equity proceeding) or a candidate for a degree who defends or opposes a thesis provided by the praeses in an academic disputation", 
"A respondent who takes an appeal from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding", 
"A respondent against whom an appeal is taken from one court or jurisdiction to another to reverse the judgment, usually in an equity proceeding", 
"A person or organization legally responsible for the content of the published material", 
"A person or organization, other than the original choreographer or director, responsible for restaging a choreographic or dramatic work and who contributes minimal new content", 
"A person, family, or organization responsible for the set of technical, editorial, and intellectual procedures aimed at compensating for the degradation of an item by bringing it back to a state as close as possible to its original condition", 
"A person or organization responsible for the review of a book, motion picture, performance, etc.", 
"A person or organization responsible for parts of a work, often headings or opening parts of a manuscript, that appear in a distinctive color, usually red", 
"A person or organization who is the author of a motion picture screenplay, generally the person who wrote the scenarios for a motion picture during the silent era", 
"A person or organization who brings scientific, pedagogical, or historical competence to the conception and realization on a work, particularly in the case of audio-visual items", 
"An author of a screenplay, script, or scene", "A person who is an amanuensis and for a writer of manuscripts proper. For a person who makes pen-facsimiles, use Facsimilist [fac]", 
"An artist responsible for creating a three-dimensional work by modeling, carving, or similar technique", 
"A person or organization who is identified as the party of the second part. In the case of transfer of right, this is the assignee, transferee, licensee, grantee, etc. Multiple parties can be named jointly as the second party", 
"A person or organization who is a recorder, redactor, or other person responsible for expressing the views of a organization", 
"A former owner of an item who sold that item to another owner", 
"A person who translates the rough sketches of the art director into actual architectural structures for a theatrical presentation, entertainment, motion picture, etc. Set designers draw the detailed guides and specifications for building the set", 
"An entity in which the activity or plot of a work takes place, e.g. a geographic place, a time period, a building, an event", 
"A person whose signature appears without a presentation or other statement indicative of provenance. When there is a presentation statement, use Inscriber [ins].", 
"A performer contributing to a resource by using his/her/their voice, with or without instrumental accompaniment, to produce music. A singer's performance may or may not include actual words", 
"A person who produces and reproduces the sound score (both live and recorded), the installation of microphones, the setting of sound levels, and the coordination of sources of sound for a production", 
"A performer contributing to a resource by speaking words, such as a lecture, speech, etc. ", 
"A person, family, or organization sponsoring some aspect of a resource, e.g., funding research, sponsoring an event", 
"A person or organization contributing to a stage resource through the overall management and supervision of a performance", 
"A person who is in charge of everything that occurs on a performance stage, and who acts as chief of all crews and assistant to a director during rehearsals", 
"An organization responsible for the development or enforcement of a standard", 
"A person or organization who creates a new plate for printing by molding or copying another printing surface", 
"A performer contributing to a resource by relaying a creator's original story with dramatic or theatrical interpretation", 
"A person or organization that supports (by allocating facilities, staff, or other resources) a project, program, meeting, event, data objects, material culture objects, or other entities capable of support", 
"A person, family, or organization contributing to a cartographic resource by providing measurements or dimensional relationships for the geographic area represented", 
"A performer contributing to a resource by giving instruction or providing a demonstration", 
"A person who is ultimately in charge of scenery, props, lights and sound for a production", 
"A director responsible for the general management and supervision of a television program", 
"A producer responsible for most of the business aspects of a television program", 
"A person under whose supervision a degree candidate develops and presents a thesis, mémoire, or text of a dissertation", 
"A person, family, or organization contributing to a resource by changing it from one system of notation to another. For a work transcribed for a different instrument or performing group, see Arranger [arr]. For makers of pen-facsimiles, use Facsimilist [fac]", 
"A person or organization who renders a text from one language into another, or from an older form of a language into the modern form", 
"A person or organization who designs the type face used in a particular item", 
"A person or organization primarily responsible for choice and arrangement of type used in an item. If the typographer is also responsible for other aspects of the graphic design of a book (e.g., Book designer [bkd]), codes for both functions may be needed", 
"A place where a university that is associated with a resource is located, for example, a university where an academic dissertation or thesis was presented", 
"A person in charge of a video production, e.g. the video recording of a stage production as opposed to a commercial motion picture. The videographer may be the camera operator or may supervise one or more camera operators. Do not confuse with cinematographer", 
"An actor contributing to a resource by providing the voice for characters in radio and audio productions and for animated characters in moving image works, as well as by providing voice overs in radio and television commercials, dubbed resources, etc.", 
"voice for characters in radio and audio productions and for animated characters in moving image works, as well as by providing voice overs in radio and television commercials, dubbed resources, etc.", 
"A person or organization who makes prints by cutting the image in relief on the end-grain of a wood block", 
"A person or organization who makes prints by cutting the image in relief on the plank side of a wood block", 
"A person or organization who writes significant material which accompanies a sound recording or other audiovisual material", 
"A person, family, or organization contributing to an expression of a work by providing an interpretation or critical explanation of the original work", 
"A writer of words added to an expression of a musical work. For lyric writing in collaboration with a composer to form an original work, see lyricist", 
"A person, family, or organization contributing to a non-textual resource by providing text for the non-textual work (e.g., writing captions for photographs, descriptions of maps).", 
"A person, family, or organization contributing to a resource by providing an introduction to the original work", 
"A person, family, or organization contributing to a resource by providing a preface to the original work", 
"A person, family, or organization contributing to a resource by providing supplementary textual content (e.g., an introduction, a preface) to the original work"
), usage = c("", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "Use for full authors who have made substantial contributions to the package and should show up in the package citation.", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "Use for package maintainers that collected code (potentially in other languages) but did not make further substantial contributions to the package.", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"Use for authors who have been contracted to write (parts of) the package and hence do not own intellectual property.", 
"Use for authors who have made smaller contributions (such as code patches etc.) but should not show up in the package citation.", 
"", "Use for all copyright holders.", "", "", "", "", "", "", 
"Use for the package maintainer.", "", "", "Use for persons who contributed data sets for the package.", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", 
"", "", "", "", "", "", "", "", "", "If the package is part of a thesis, use for the thesis advisor.", 
"", "If the R code is merely a translation from another language (typically S), use for the translator to R.", 
"", "", "", "", "", "", "", "", "", "", "", "", "", "", "")), .Names = c("term", 
"code", "description", "usage"), row.names = c(NA, -268L), class = "data.frame")
MARC_relator_db_codes_used_with_R <-
c("aut", "com", "ctr", "ctb", "cph", "cre", "dtc", "ths", "trl"
)
