#!/usr/bin/perl -w
###########################################################
#
#betacon: Predict the beta-residue pairing, strand pairing, 
# strand pairing direction, strand alignment, beta-sheet
# architecture, and contact map.
#
#configure.pl: to configure the installation of betacon 
#
#Author: Jianlin cheng
#
#Free for academic use only.
#All rights reserved.
#
##########################################################

#######Customize settings here##############
#
#set installation directory of BETApro
$install_dir = "/exports/store1/tool/betacon/";

#set the fullpath of prosys bin directory
#$pspro_dir = "/home/chengji/software/pspro/";
$pspro_dir = "/exports/store1/tool/pspro2.0/";

#
######End of Customization##################


################Don't Change the code below##############
if (! -d $install_dir)
{
	die "can't find installation directory.\n";
}
if ( substr($install_dir, length($install_dir) - 1, 1) ne "/" )
{
	$install_dir .= "/"; 
}
if (! -d $pspro_dir)
{
	die "can't find Pspro directory.\n";
}
if ( substr($pspro_dir, length($pspro_dir) - 1, 1) ne "/" )
{
	$pspro_dir .= "/"; 
}

#check if the installation directory is right
#the configuration file must run in the installation directory
$cur_dir = `pwd`;  
chomp $cur_dir; 
$configure_file = "$cur_dir/configure.pl";
if (! -f $configure_file || $install_dir ne "$cur_dir/")
{
	die "Please check the installation directory setting and run the configure program there.\n";
}

$bin_dir = "${install_dir}bin/";
#$data_dir = "${install_dir}data/";
$model_dir = "${install_dir}model/";
$script_dir = "${install_dir}script/";
$server_dir = "${install_dir}server/";
#$test_dir = "${install_dir}train/";

if ( ! -d $bin_dir || ! -d $model_dir || ! -d $script_dir
   || ! -d $server_dir )
{
	die "some sub directories don't exist. check the installation tar ball.\n";
}

$betapro_exe = "${server_dir}predict_seq_map";
$beta_full_sh = "${bin_dir}predict_beta_full.sh";
$beta_fasta_sh = "${bin_dir}predict_beta_fasta.sh";
$beta_format_sh = "${bin_dir}predict_beta_format.sh";
$beta_simple_sh = "${bin_dir}predict_beta_simple.sh";
$beta_ss_sh = "${bin_dir}predict_beta_ss.sh";
$predict_strand = "${bin_dir}predict_strand.sh";
$strand_exe = "${server_dir}span_pair_pre";
$matrix2png_sh = "${bin_dir}matrix2png.sh";

$betapro_model_dir = "${model_dir}betapro/";
$betapro_model_def = "${model_dir}model.def";
$pspro_exe = "${pspro_dir}bin/predict_ssa.sh"; 

print "generate betapro server script...\n";
open(SERVER_SH, ">$beta_full_sh") || die "can't write beta full shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict beta-sheet structure for one sequence.\n";
print SERVER_SH "if [ \$# -ne 5 ]\n";
print SERVER_SH "then\n\techo \"need five parameters:seq_file(9-line), alignment file, threshold, binary(1:binary, 0:probability), output file.\"\n\texit 1\nfi\n";
print SERVER_SH "$betapro_exe $betapro_model_def \$1 \$2 \$3 \$4 >\$5 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$beta_format_sh") || die "can't write beta format shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict beta-sheet structure for one sequence.\n";
print SERVER_SH "if [ \$# -ne 6 ]\n";
print SERVER_SH "then\n\techo \"need six parameters:1. seq_file(9-line with a title), 2. alignment file, 3. prob threshold, 4. binary(1:binary, 0:probability), 5. format(1:matrix only, 2:name,seq,ss,bp1,bp2,matrix), 6. output file.\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_seq_emap.pl $beta_full_sh \$1 \$6 \$2 \$3 \$5 \$4 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$beta_simple_sh") || die "can't write beta simple shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict beta-sheet structure for one sequence.\n";
print SERVER_SH "if [ \$# -ne 3 ]\n";
print SERVER_SH "then\n\techo \"need three parameters:1. seq_file(name,seq,ss,sa), 2. alignment file, 3.output file(name,seq,ss,bp1,bp2,matrix).\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_seq_bmap.pl $beta_format_sh \$1 \$2 \$3 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$beta_fasta_sh") || die "can't write beta fasta shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict beta-sheet structure for one sequence.\n";
print SERVER_SH "if [ \$# -ne 2 ]\n";
print SERVER_SH "then\n\techo \"need two parameters:1. seq_file(fasta), 2.output file(name,seq,ss,bp1,bp2,matrix).\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_fasta_beta.pl $pspro_exe $beta_simple_sh \$1 \$2 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$beta_ss_sh") || die "can't write beta ss shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict beta-sheet structure for one sequence with user defined ss.\n";
print SERVER_SH "if [ \$# -ne 2 ]\n";
print SERVER_SH "then\n\techo \"need two parameters:1. seq_file(>name, seq, ss), 2.output file(name,seq,ss,bp1,bp2,matrix).\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_ss_beta.pl $pspro_exe $beta_simple_sh \$1 \$2 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$predict_strand") || die "can't write predict strand shell script.\n";
print SERVER_SH "#!/bin/sh\n#predict strands from beta residue pairing map.\n";
print SERVER_SH "if [ \$# -ne 2 ]\n";
print SERVER_SH "then\n\techo \"need two parameters:1. beta-residue pairing map(name, seq, ss,sa,bp1,bp2,matrix), 2.output file prefix(.str:strand file, .viz: graph viz file).\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}predict_strand_pair.pl $strand_exe \$1 \$2 \n"; 
close SERVER_SH;

print "generate betapro server script...\n";
open(SERVER_SH, ">$matrix2png_sh") || die "can't write convert matrix to png image shell script.\n";
print SERVER_SH "#!/bin/sh\n#Create png image file from residue pairing map.\n";
print SERVER_SH "#Precondition: GD package must be installed.\n";
print SERVER_SH "if [ \$# -ne 4 ]\n";
print SERVER_SH "then\n\techo \"need four parameters:1. beta-residue pairing map(name, seq, ss,sa,bp1,bp2,matrix), 2.image scale(8), 3.Probability threshold(0.15), 4.output file.\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}matrix2png.pl \$1 \$2 \$3 \$4\n"; 
close SERVER_SH;


$betacon = "${bin_dir}beta_contact_map.sh";
print "generate betapro server script...\n";
open(SERVER_SH, ">$betacon") || die "can't write beta contact map script.\n";
print SERVER_SH "#!/bin/sh\n#Augument full contact map with beta-residue pairings\n";
print SERVER_SH "if [ \$# -ne 2 ]\n";
print SERVER_SH "then\n\techo \"need two parameters:1.fasta file, 2.output dir.\"\n\texit 1\nfi\n";
print SERVER_SH "${script_dir}betamap.pl $pspro_dir $install_dir \$1 \$2 \n"; 
close SERVER_SH;










print "generate betapro model definition file...\n";
opendir(MODEL_DIR, "$betapro_model_dir") || die "can't open the betapro model dir.\n";
open(MODEL_DEF, ">$betapro_model_def") || die "can't create betapro model def file.\n";
@file_list = readdir(MODEL_DIR);
closedir(MODEL_DIR); 
if (@file_list < 3)
{
	die "can't find betapro model file. check intallation tar ball.\n";
}
$model_num = @file_list;
$model_num -= 2; 
print MODEL_DEF "$model_num\n";
while (@file_list)
{
	$model_file = shift @file_list;
	if ($model_file ne "." && $model_file ne ".." && $model_file ne "CVS")
	{
		print MODEL_DEF "$betapro_model_dir$model_file\n";
	}
}
close MODEL_DEF; 
`chmod 755 $beta_full_sh $beta_format_sh $beta_simple_sh $beta_fasta_sh $beta_ss_sh $predict_strand $matrix2png_sh`; 

`chmod 755 $bin_dir/*.sh`; 

