#!/usr/bin/perl -w
###############################################################################
#predict beta-residue pairing map  for a single sequence in compact format
#input parameters:
#1. beta map predictor(such as predict_full_format.sh)
#2. input sequence file(four lines: name(shouldn't include . or space in name), seq, SS, SA (all in compact format))
#3. alignment alignment file 
#4 output file(name, seq, ss, bp1(meaningless), bp2(meaningless), prob matrix)
#
#March 15, 2005, Jianlin Cheng
###############################################################################

if (@ARGV != 4)
{
	die "need four parameters: beta map predictor, input_sequence, align_file, output file\n";
}

$beta_predictor = shift @ARGV; 
$seq_file = shift @ARGV;
$align_file = shift @ARGV;
$output_file = shift  @ARGV; 

if (! -f $beta_predictor)
{
	die "can't find beta pairing predictor.\n"; 
}

if (! -f $align_file)
{
	warn "the alignment file doesn't exists.\n"; 
}

if (! -f $seq_file)
{
	die "can't find the sequence file.\n"; 
}

#open(OUTPUT, ">$output_file") || die "can't create output file.\n"; 

open(SEQ_FILE, "$seq_file") || die "can't open sequence file.\n";

@content = <SEQ_FILE>;
close(SEQ_FILE);

#read sequence information
$name = shift @content;
chomp $name; 
$name =~ s/\s//g;
$sequence = shift @content;
chomp $sequence; 
$sequence =~ s/\s//g;
$sstx = shift @content; 
chomp $sstx;
$solv = shift @content; 
chomp $solv; 

if (length($sequence) != length($sstx) || length($sequence) != length($solv) )
{
	die "sequence length doesn't equal the length of ss or sa.\n"; 
}

#create a temporary file and make prediction
open(TEMP, ">$seq_file.tmp") || die "can't create temporary file.\n";
print TEMP "1 20 3\n"; #create a title line required by CMpro
print TEMP "$name\n"; 
$seq_len = length($sequence); 
print TEMP "$seq_len\n"; 

#create a format required by beta-predictor 
$sep_seq = ""; 
$sep_sstx = ""; 
$sep_bind1= ""; 
$sep_bind2= "";
$sep_solv = ""; 
$sep_xyz = ""; 
for($t=0; $t < $seq_len; $t++)
{
	$sep_seq .= substr($sequence, $t, 1); 
	$sep_seq .= " "; 
	$sep_sstx .= substr($sstx, $t, 1); 
	$sep_sstx .= " "; 
	$sep_bind1 .= "0 "; 
	$sep_bind2 .= "0 ";
	if (substr($solv, $t, 1) eq "e")
	{
		$sep_solv .= "50 "; 
	}
	else
	{
		$sep_solv .= "10 "; 
	}
	$sep_xyz .= "1 1 1 "; 	
}
print TEMP "$sep_seq\n$sep_sstx\n$sep_bind1\n$sep_bind2\n$sep_solv\n$sep_xyz\n\n"; 
close(TEMP);

#make prediction
#foramt: sequence file, alignment file, prob thresh, binary/prob(0:prob), 
#format(1:matrix only, 2:name,seq,ss,bp1,bp2,matrix), output file.
$command = "$beta_predictor $seq_file.tmp $align_file 0.15 0 2 $output_file"; 
system($command); 

#remove the temporary files
`rm $seq_file.tmp`;

