#!/usr/bin/perl -w

##############################################################################
#Given a 9-line dataset, predict a H-Bond bonding matrix for each sequence
#Format: 1: matrix only,  2: Name, Sequence, SS, BP1, BP2, matrix
#Input Parameters: 9-line dataset, output directory 
#Author: Jianlin Cheng
#Date: 9/14/2004
#############################################################################

if (@ARGV != 8)
{
	die "need 8 params: 1.h-bond predictor, 2.model definition file, 3.input 9-line dataset (with a title), 4.output dir, 5.alignment dir, 6.threshold, 7.format(1:matrix only, 2:name,seq,ss,bp1,bp2, matrix), 8.binary(1:binary, 0:probability(threshold won't affect anymore) )\n"; 
}

$predictor = shift @ARGV;
$model_def = shift @ARGV; 
$input_set = shift @ARGV;
$output_dir = shift @ARGV;
$align_dir = shift @ARGV; 
$threshold = shift @ARGV; 
$format = shift @ARGV; 
$binary = shift @ARGV; 

if (! -f $predictor)
{
	die "can't find h-bond predictor: $predictor\n";  
}

if (! -f $model_def)
{
	die "can't find model definition file: $model_def\n"; 
}

open(INPUT, "$input_set") || die "can't open input file.\n"; 
if (! -d $output_dir)
{
	die "output directory doesn't exist.\n"; 
}

if ( substr($output_dir, length($output_dir) - 1, 1) ne "/" )
{
        $output_dir .= "/";
}
if (! -d $align_dir)
{
	die "align directory doesn't exist.\n"; 
}

if ( substr($align_dir, length($align_dir) - 1, 1) ne "/" )
{
        $align_dir .= "/";
}

@context = <INPUT>;
close INPUT; 
shift @context; 

while(@context)
{
	$name = shift @context;
	chomp $name;
	$length = shift @context;
	chomp $length; 
	$seq = shift @context;
	chomp $seq;
	$ss = shift @context;
	chomp $ss;
	$bp1 = shift @context;
	chomp $bp1;
	$bp2 = shift @context; 
	chomp $bp2;
	$sa = shift @context;
	chomp $sa;
	$coor = shift @context;
	chomp $coor;
	shift @context; 

	#check if alignment file exists
	$align_file = $align_dir . $name; 
	if (! -f $align_file)
	{
		die "alignment file: $align_file doesn't exists.\n"; 
	}

	open(TMP, ">$output_dir$name.tmp") || die "can't create tmp file.\n"; 
	print TMP "1 20 3\n$name\n$length\n$seq\n$ss\n$bp1\n$bp2\n$sa\n$coor\n\n"; 
	close TMP; 
	if ($format == 1)
	{
		system("$predictor $model_def $output_dir$name.tmp $align_file $threshold $binary > $output_dir$name");  
	}
	if ($format == 2)
	{
		@aa_vec = split(/\s+/, $seq);
		@ss_vec = split(/\s+/, $ss); 
		open(OUT, ">$output_dir$name"); 
		print OUT "$name\n"; 
		print OUT join("", @aa_vec), "\n";
		print OUT join("", @ss_vec), "\n";
		print OUT "$bp1\n$bp2\n"; 
		close OUT; 
		system("$predictor $model_def $output_dir$name.tmp $align_file $threshold $binary >> $output_dir$name");  
	}

	`rm $output_dir$name.tmp`; 
}








